/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Joiner;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AuthenticationServiceException;

public class SignedAuthRequestUrlBuilder
implements AuthRequestUrlBuilder {
    private JwtSigningAndValidationService signingAndValidationService;

    @Override
    public String buildAuthRequestUrl(ServerConfiguration serverConfig, RegisteredClient clientConfig, String redirectUri, String nonce, String state, Map<String, String> options) {
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setClaim("response_type", (Object)"code");
        claims.setClaim("client_id", (Object)clientConfig.getClientId());
        claims.setClaim("scope", (Object)Joiner.on((String)" ").join((Iterable)clientConfig.getScope()));
        claims.setClaim("redirect_uri", (Object)redirectUri);
        claims.setClaim("nonce", (Object)nonce);
        claims.setClaim("state", (Object)state);
        for (Map.Entry<String, String> option : options.entrySet()) {
            claims.setClaim(option.getKey(), (Object)option.getValue());
        }
        SignedJWT jwt = new SignedJWT(new JWSHeader(this.signingAndValidationService.getDefaultSigningAlgorithm()), (ReadOnlyJWTClaimsSet)claims);
        this.signingAndValidationService.signJwt(jwt);
        try {
            URIBuilder uriBuilder = new URIBuilder(serverConfig.getAuthorizationEndpointUri());
            uriBuilder.addParameter("request", jwt.serialize());
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Malformed Authorization Endpoint Uri", (Throwable)e);
        }
    }

    public JwtSigningAndValidationService getSigningAndValidationService() {
        return this.signingAndValidationService;
    }

    public void setSigningAndValidationService(JwtSigningAndValidationService signingAndValidationService) {
        this.signingAndValidationService = signingAndValidationService;
    }
}

