/*
 * TeleStax, Open Source Cloud Communications
 * Copyright 2012, Telestax Inc and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.protocols.ss7.isup;

import java.util.EventObject;

import org.mobicents.protocols.ss7.isup.message.ISUPMessage;

/**
 * Class delivered to listeners. To be extended if requried.
 *
 * @author baranowb
 *
 */
public class ISUPEvent extends EventObject {

    protected final ISUPMessage message;
    private int dpc;

    /**
     * @param message
     * @param circuit
     */
    public ISUPEvent(Object source, ISUPMessage message, int dpc) {
        super(source);
        this.message = message;
        this.dpc = dpc;
    }

    public ISUPMessage getMessage() {
        return message;
    }

    public int getDpc() {
        return dpc;
    }

    @Override
    public String toString() {
        return "ISUPEvent [dpc=" + dpc + ", message=" + message.toString() + "]";
    }

}
