/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.isup.CircuitManager;
import org.mobicents.protocols.ss7.isup.ISUPMessageFactory;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ISUPProvider;
import org.mobicents.protocols.ss7.isup.ISUPStack;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.ISUPProviderImpl;
import org.mobicents.protocols.ss7.isup.impl.message.AbstractISUPMessage;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartListener;
import org.mobicents.protocols.ss7.scheduler.Scheduler;

public class ISUPStackImpl
implements ISUPStack,
Mtp3UserPartListener {
    private Logger logger = Logger.getLogger(ISUPStackImpl.class);
    private State state = State.IDLE;
    private Mtp3UserPart mtp3UserPart = null;
    private CircuitManager circuitManager = null;
    private ISUPProviderImpl provider;
    private ISUPMessageFactory messageFactory;
    private ISUPParameterFactory parameterFactory;
    private Scheduler scheduler;

    public ISUPStackImpl(Scheduler scheduler, int localSpc, int ni, boolean automaticTimerMessages) {
        this.scheduler = scheduler;
        this.provider = new ISUPProviderImpl(this, scheduler, ni, localSpc, automaticTimerMessages);
        this.parameterFactory = this.provider.getParameterFactory();
        this.messageFactory = this.provider.getMessageFactory();
        this.state = State.CONFIGURED;
    }

    public ISUPStackImpl(Scheduler scheduler, int localSpc, int ni) {
        this(scheduler, localSpc, ni, true);
    }

    public ISUPProvider getIsupProvider() {
        return this.provider;
    }

    public void start() throws IllegalStateException {
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Stack has not been configured or is already running!");
        }
        if (this.state == State.RUNNING) {
            throw new IllegalStateException("Can not start stack again!");
        }
        if (this.mtp3UserPart == null) {
            throw new IllegalStateException("No Mtp3UserPart present!");
        }
        if (this.circuitManager == null) {
            throw new IllegalStateException("No CircuitManager present!");
        }
        this.provider.start();
        this.mtp3UserPart.addMtp3UserPartListener((Mtp3UserPartListener)this);
        this.state = State.RUNNING;
    }

    public void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stack is not running!");
        }
        this.mtp3UserPart.removeMtp3UserPartListener((Mtp3UserPartListener)this);
        this.provider.stop();
        this.state = State.CONFIGURED;
    }

    public Mtp3UserPart getMtp3UserPart() {
        return this.mtp3UserPart;
    }

    public void setMtp3UserPart(Mtp3UserPart mtp3UserPart) {
        this.mtp3UserPart = mtp3UserPart;
    }

    public void setCircuitManager(CircuitManager mgr) {
        this.circuitManager = mgr;
    }

    public CircuitManager getCircuitManager() {
        return this.circuitManager;
    }

    void send(Mtp3TransferPrimitive message) throws IOException {
        if (this.state != State.RUNNING) {
            return;
        }
        try {
            this.mtp3UserPart.sendMessage(message);
        }
        catch (IOException e) {
            this.logger.error((Object)("IOException when sending the message to MTP3 level: " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public void onMtp3PauseMessage(Mtp3PausePrimitive arg0) {
    }

    public void onMtp3ResumeMessage(Mtp3ResumePrimitive arg0) {
    }

    public void onMtp3StatusMessage(Mtp3StatusPrimitive arg0) {
    }

    public void onMtp3TransferMessage(Mtp3TransferPrimitive mtpMsg) {
        if (this.state != State.RUNNING) {
            return;
        }
        if (mtpMsg.getSi() != 5) {
            return;
        }
        byte[] payload = mtpMsg.getData();
        byte commandCode = payload[2];
        AbstractISUPMessage msg = (AbstractISUPMessage)this.messageFactory.createCommand((int)commandCode);
        try {
            msg.decode(payload, this.parameterFactory);
        }
        catch (ParameterException e) {
            this.logger.error((Object)("Error decoding of incoming Mtp3TransferPrimitive" + e.getMessage()), (Throwable)e);
            e.printStackTrace();
        }
        msg.setSls(mtpMsg.getSls());
        this.provider.receive(msg, mtpMsg.getOpc());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

