/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.NAINumber;

public abstract class AbstractNAINumber
extends AbstractNumber
implements NAINumber {
    protected int natureOfAddresIndicator;

    public AbstractNAINumber(byte[] representation) throws ParameterException {
        super(representation);
    }

    public AbstractNAINumber(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public AbstractNAINumber(int natureOfAddresIndicator, String address) {
        super(address);
        this.natureOfAddresIndicator = natureOfAddresIndicator;
    }

    public AbstractNAINumber() {
    }

    public int decode(byte[] b) throws ParameterException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        return this.decode(bis);
    }

    public int getNatureOfAddressIndicator() {
        return this.natureOfAddresIndicator;
    }

    public void setNatureOfAddresIndicator(int natureOfAddresIndicator) {
        this.natureOfAddresIndicator = natureOfAddresIndicator;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = this.natureOfAddresIndicator & 0x7F;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b);
        return 1;
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.natureOfAddresIndicator = b & 0x7F;
        return 1;
    }
}

