/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.CallDiversionInformation;

public class CallDiversionInformationImpl
extends AbstractISUPParameter
implements CallDiversionInformation {
    private int redirectingReason = 0;
    private int notificationSubscriptionOptions = 0;

    public CallDiversionInformationImpl(int notificationSubscriptionOptions, int redirectingReason) {
        this.notificationSubscriptionOptions = notificationSubscriptionOptions;
        this.redirectingReason = redirectingReason;
    }

    public CallDiversionInformationImpl() {
    }

    public CallDiversionInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 1) {
            throw new ParameterException("byte[] must not be null or have different size than 1");
        }
        byte v = b[0];
        this.notificationSubscriptionOptions = v & 7;
        this.redirectingReason = v >> 3 & 0xF;
        return 1;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = new byte[1];
        int v = 0;
        v |= this.notificationSubscriptionOptions & 7;
        b[0] = (byte)(v |= (this.redirectingReason & 0xF) << 3);
        return b;
    }

    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    public int getNotificationSubscriptionOptions() {
        return this.notificationSubscriptionOptions;
    }

    public void setNotificationSubscriptionOptions(int notificationSubscriptionOptions) {
        this.notificationSubscriptionOptions = notificationSubscriptionOptions;
    }

    public int getRedirectingReason() {
        return this.redirectingReason;
    }

    public void setRedirectingReason(int redirectingReason) {
        this.redirectingReason = redirectingReason;
    }

    public int getCode() {
        return 54;
    }
}

