/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledNumber;

public abstract class CalledNumberImpl
extends AbstractNAINumber
implements CalledNumber {
    protected int numberingPlanIndicator;
    protected int addressRepresentationRestrictedIndicator;

    public CalledNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CalledNumberImpl() {
    }

    public CalledNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CalledNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int addressRepresentationREstrictedIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        return 1;
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = (this.numberingPlanIndicator & 7) << 4;
        bos.write(c |= (this.addressRepresentationRestrictedIndicator & 3) << 2);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }
}

