/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledPartyNumber;

public class CalledPartyNumberImpl
extends AbstractNAINumber
implements CalledPartyNumber {
    protected int numberingPlanIndicator;
    protected int internalNetworkNumberIndicator;

    public CalledPartyNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CalledPartyNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CalledPartyNumberImpl() {
    }

    public CalledPartyNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int internalNetworkNumberIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.internalNetworkNumberIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        return 1;
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = (this.numberingPlanIndicator & 7) << 4;
        bos.write(c |= (this.internalNetworkNumberIndicator & 1) << 7);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getInternalNetworkNumberIndicator() {
        return this.internalNetworkNumberIndicator;
    }

    public void setInternalNetworkNumberIndicator(int internalNetworkNumberIndicator) {
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int getCode() {
        return 4;
    }

    public String toString() {
        return "CalledPartyNumber [numberingPlanIndicator=" + this.numberingPlanIndicator + ", internalNetworkNumberIndicator=" + this.internalNetworkNumberIndicator + ", natureOfAddresIndicator=" + this.natureOfAddresIndicator + ", oddFlag=" + this.oddFlag + ", address=" + this.address + "]";
    }
}

