/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CallingPartyNumber;

public class CallingPartyNumberImpl
extends AbstractNAINumber
implements CallingPartyNumber {
    protected int numberingPlanIndicator;
    protected int numberIncompleteIndicator;
    protected int addressRepresentationREstrictedIndicator;
    protected int screeningIndicator;

    public CallingPartyNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CallingPartyNumberImpl() {
    }

    public CallingPartyNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CallingPartyNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int numberIncompleteIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.numberIncompleteIndicator = numberIncompleteIndicator;
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberIncompleteIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationREstrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.numberIncompleteIndicator << 7;
        c |= this.addressRepresentationREstrictedIndicator << 2;
        bos.write(c |= this.screeningIndicator);
        return 1;
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationREstrictedIndicator == 2) {
            this.oddFlag = 0;
            this.natureOfAddresIndicator = 0;
            this.numberIncompleteIndicator = 0;
            this.numberingPlanIndicator = 0;
            this.setAddress("");
        }
    }

    public int encodeDigits(ByteArrayOutputStream bos) {
        if (this.addressRepresentationREstrictedIndicator == 2) {
            bos.write(240);
            return 1;
        }
        return super.encodeDigits(bos);
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getNumberIncompleteIndicator() {
        return this.numberIncompleteIndicator;
    }

    public void setNumberIncompleteIndicator(int numberIncompleteIndicator) {
        this.numberIncompleteIndicator = numberIncompleteIndicator;
    }

    public int getAddressRepresentationREstrictedIndicator() {
        return this.addressRepresentationREstrictedIndicator;
    }

    public void setAddressRepresentationREstrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 10;
    }
}

