/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;

public class CauseIndicatorsImpl
extends AbstractISUPParameter
implements CauseIndicators {
    private int location = 0;
    private int causeValue = 0;
    private int codingStandard = 0;
    private byte[] diagnostics = null;

    public CauseIndicatorsImpl() {
    }

    public CauseIndicatorsImpl(int codingStandard, int location, int causeValue, byte[] diagnostics) {
        this.setCodingStandard(codingStandard);
        this.setLocation(location);
        this.setCauseValue(causeValue);
        this.diagnostics = diagnostics;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must not be null or has size less than 2");
        }
        int index = 0;
        int v = 0;
        v = b[index] & 0x7F;
        this.location = v & 0xF;
        this.codingStandard = v >> 5;
        index = (b[index] & 0x7F) >> 7 == 0 ? (index += 2) : ++index;
        v = 0;
        this.causeValue = v = b[1] & 0x7F;
        if (b.length == 2) {
            return 2;
        }
        if ((b.length - 2) % 3 != 0) {
            throw new ParameterException("Diagnostics part  must have 3xN bytes, it has: " + (b.length - 2));
        }
        int byteCounter = 2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 2; i < b.length; ++i) {
            bos.write(b[i]);
            ++byteCounter;
        }
        this.diagnostics = bos.toByteArray();
        return byteCounter;
    }

    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int v = this.location & 0xF;
        bos.write(v |= (byte)((this.codingStandard & 3) << 5) | 0x80);
        bos.write(this.causeValue | 0x80);
        if (this.diagnostics != null) {
            try {
                bos.write(this.diagnostics);
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        byte[] b = bos.toByteArray();
        return b;
    }

    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    public int getCodingStandard() {
        return this.codingStandard;
    }

    public void setCodingStandard(int codingStandard) {
        this.codingStandard = codingStandard & 3;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location & 0xF;
    }

    public int getCauseValue() {
        return this.causeValue & 0x7F;
    }

    public void setCauseValue(int causeValue) {
        this.causeValue = causeValue;
    }

    public byte[] getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(byte[] diagnostics) {
        this.diagnostics = diagnostics;
    }

    public int getCode() {
        return 18;
    }
}

