/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.ForwardCallIndicators;

public class ForwardCallIndicatorsImpl
extends AbstractISUPParameter
implements ForwardCallIndicators {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private boolean nationalCallIdentificator = false;
    private int endToEndMethodIndicator = 0;
    private boolean interworkingIndicator = false;
    private boolean endToEndInformationIndicator = false;
    private boolean isdnUserPartIndicator = false;
    private int isdnUserPartReferenceIndicator = 0;
    private int sccpMethodIndicator = 0;
    private boolean isdnAccessIndicator = false;

    public ForwardCallIndicatorsImpl() {
    }

    public ForwardCallIndicatorsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public ForwardCallIndicatorsImpl(boolean nationalCallIdentificator, int endToEndMethodIndicator, boolean interworkingIndicator, boolean endToEndInformationIndicator, boolean isdnUserPartIndicator, int isdnUserPartReferenceIndicator, int sccpMethodIndicator, boolean isdnAccessIndicator) {
        this.nationalCallIdentificator = nationalCallIdentificator;
        this.endToEndMethodIndicator = endToEndMethodIndicator;
        this.interworkingIndicator = interworkingIndicator;
        this.endToEndInformationIndicator = endToEndInformationIndicator;
        this.isdnUserPartIndicator = isdnUserPartIndicator;
        this.isdnUserPartReferenceIndicator = isdnUserPartReferenceIndicator;
        this.sccpMethodIndicator = sccpMethodIndicator;
        this.isdnAccessIndicator = isdnAccessIndicator;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 2) {
            throw new IllegalArgumentException("byte[] must not be null or have different size than 2");
        }
        byte v = 0;
        v = b[0];
        this.nationalCallIdentificator = (v & 1) == 1;
        this.endToEndMethodIndicator = v >> 1 & 3;
        this.interworkingIndicator = (v >> 3 & 1) == 1;
        this.endToEndInformationIndicator = (v >> 4 & 1) == 1;
        this.isdnUserPartIndicator = (v >> 5 & 1) == 1;
        this.isdnUserPartReferenceIndicator = v >> 6 & 3;
        v = b[1];
        this.isdnAccessIndicator = (v & 1) == 1;
        this.sccpMethodIndicator = v >> 1 & 3;
        return 2;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = new byte[2];
        b[0] = (byte)(b[0] | (this.nationalCallIdentificator ? (byte)1 : 0));
        b[0] = (byte)(b[0] | (this.endToEndMethodIndicator & 3) << 1);
        b[0] = (byte)(b[0] | (this.interworkingIndicator ? 1 : 0) << 3);
        b[0] = (byte)(b[0] | (this.endToEndInformationIndicator ? 1 : 0) << 4);
        b[0] = (byte)(b[0] | (this.isdnUserPartIndicator ? 1 : 0) << 5);
        b[0] = (byte)(b[0] | (this.isdnUserPartReferenceIndicator & 3) << 6);
        b[1] = (byte)(this.isdnAccessIndicator ? 1 : 0);
        b[1] = (byte)(b[1] | (this.sccpMethodIndicator & 3) << 1);
        return b;
    }

    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    public boolean isNationalCallIdentificator() {
        return this.nationalCallIdentificator;
    }

    public void setNationalCallIdentificator(boolean nationalCallIdentificator) {
        this.nationalCallIdentificator = nationalCallIdentificator;
    }

    public int getEndToEndMethodIndicator() {
        return this.endToEndMethodIndicator;
    }

    public void setEndToEndMethodIndicator(int endToEndMethodIndicator) {
        this.endToEndMethodIndicator = endToEndMethodIndicator;
    }

    public boolean isInterworkingIndicator() {
        return this.interworkingIndicator;
    }

    public void setInterworkingIndicator(boolean interworkingIndicator) {
        this.interworkingIndicator = interworkingIndicator;
    }

    public boolean isEndToEndInformationIndicator() {
        return this.endToEndInformationIndicator;
    }

    public void setEndToEndInformationIndicator(boolean endToEndInformationIndicator) {
        this.endToEndInformationIndicator = endToEndInformationIndicator;
    }

    public boolean isIsdnUserPartIndicator() {
        return this.isdnUserPartIndicator;
    }

    public void setIsdnUserPartIndicator(boolean isdnUserPartIndicator) {
        this.isdnUserPartIndicator = isdnUserPartIndicator;
    }

    public int getIsdnUserPartReferenceIndicator() {
        return this.isdnUserPartReferenceIndicator;
    }

    public void setIsdnUserPartReferenceIndicator(int isdnUserPartReferenceIndicator) {
        this.isdnUserPartReferenceIndicator = isdnUserPartReferenceIndicator;
    }

    public int getSccpMethodIndicator() {
        return this.sccpMethodIndicator;
    }

    public void setSccpMethodIndicator(int sccpMethodIndicator) {
        this.sccpMethodIndicator = sccpMethodIndicator;
    }

    public boolean isIsdnAccessIndicator() {
        return this.isdnAccessIndicator;
    }

    public void setIsdnAccessIndicator(boolean isdnAccessIndicator) {
        this.isdnAccessIndicator = isdnAccessIndicator;
    }

    public int getCode() {
        return 7;
    }
}

