/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNumber;

public class GenericNumberImpl
extends AbstractNAINumber
implements GenericNumber {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    protected int numberQualifierIndicator;
    protected int numberingPlanIndicator;
    protected int addressRepresentationRestrictedIndicator;
    protected boolean numberIncomplete;
    protected int screeningIndicator;

    public GenericNumberImpl(int natureOfAddresIndicator, String address, int numberQualifierIndicator, int numberingPlanIndicator, int addressRepresentationREstrictedIndicator, boolean numberIncomplete, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberQualifierIndicator = numberQualifierIndicator;
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
        this.numberIncomplete = numberIncomplete;
        this.screeningIndicator = screeningIndicator;
    }

    public GenericNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public GenericNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public GenericNumberImpl() {
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberIncomplete = (b & 0x80) >> 7 == 1;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationRestrictedIndicator != 2) {
            return;
        }
        this.oddFlag = 0;
        this.natureOfAddresIndicator = 0;
        this.numberingPlanIndicator = 0;
        this.numberIncomplete = false;
        this.screeningIndicator = 3;
        this.setAddress("");
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.screeningIndicator;
        c |= this.addressRepresentationRestrictedIndicator << 2;
        c |= this.numberingPlanIndicator << 4;
        bos.write(c |= (this.numberIncomplete ? 1 : 0) << 7);
        return 1;
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        this.numberQualifierIndicator = bis.read() & 0xFF;
        return super.decodeHeader(bis) + 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        bos.write(this.numberQualifierIndicator);
        return super.encodeHeader(bos) + 1;
    }

    public int getNumberQualifierIndicator() {
        return this.numberQualifierIndicator;
    }

    public void setNumberQualifierIndicator(int numberQualifierIndicator) {
        this.numberQualifierIndicator = numberQualifierIndicator;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator & 7;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator & 3;
    }

    public boolean isNumberIncomplete() {
        return this.numberIncomplete;
    }

    public void setNumberIncompleter(boolean numberIncomplete) {
        this.numberIncomplete = numberIncomplete;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator & 3;
    }

    public int getCode() {
        return 192;
    }
}

