/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.LocationNumber;

public class LocationNumberImpl
extends AbstractNAINumber
implements LocationNumber {
    protected int numberingPlanIndicator;
    protected int internalNetworkNumberIndicator;
    protected int addressRepresentationREstrictedIndicator;
    protected int screeningIndicator;

    public LocationNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int internalNetworkNumberIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    public LocationNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public LocationNumberImpl() {
    }

    public LocationNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.internalNetworkNumberIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationREstrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationREstrictedIndicator != 2) {
            return;
        }
        this.oddFlag = 0;
        this.natureOfAddresIndicator = 0;
        this.numberingPlanIndicator = 0;
        this.internalNetworkNumberIndicator = 0;
        this.screeningIndicator = 3;
        this.setAddress("");
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.internalNetworkNumberIndicator << 7;
        c |= this.addressRepresentationREstrictedIndicator << 2;
        bos.write(c |= this.screeningIndicator);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getInternalNetworkNumberIndicator() {
        return this.internalNetworkNumberIndicator;
    }

    public void setInternalNetworkNumberIndicator(int internalNetworkNumberIndicator) {
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationREstrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 63;
    }
}

