/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.InstructionIndicatorsImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.InstructionIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;

public class ParameterCompatibilityInformationImpl
extends AbstractISUPParameter
implements ParameterCompatibilityInformation {
    private List<Byte> parameterCodes = new ArrayList<Byte>();
    private List<InstructionIndicators> instructionIndicators = new ArrayList<InstructionIndicators>();

    public ParameterCompatibilityInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public ParameterCompatibilityInformationImpl() {
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must  not be null and length must  greater than 1");
        }
        ByteArrayOutputStream bos = null;
        boolean newParameter = true;
        byte parameterCode = 0;
        for (int index = 0; index < b.length; ++index) {
            if (newParameter) {
                parameterCode = b[index];
                bos = new ByteArrayOutputStream();
                newParameter = false;
                continue;
            }
            bos.write(b[index]);
            if ((b[index] >> 7 & 1) != 0) continue;
            if (bos.size() < 3) {
                this.addInstructions(parameterCode, new InstructionIndicatorsImpl(bos.toByteArray()));
            } else {
                this.addInstructions(parameterCode, new InstructionIndicatorsImpl(bos.toByteArray(), true));
            }
            newParameter = true;
        }
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int index = 0; index < this.parameterCodes.size(); ++index) {
            bos.write(this.parameterCodes.get(index).byteValue());
            try {
                bos.write(((AbstractISUPParameter)this.instructionIndicators.get(index)).encode());
                continue;
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    public void addInstructions(Byte parameterCode, InstructionIndicators instructionIndicators) {
        this.parameterCodes.add(parameterCode);
        this.instructionIndicators.add(instructionIndicators);
    }

    public InstructionIndicators getInstructionIndicators(int index) {
        return this.instructionIndicators.get(index);
    }

    public Byte getParameterCode(int index) {
        return this.parameterCodes.get(index);
    }

    public int size() {
        return this.instructionIndicators.size();
    }

    public void remove(int index) {
        this.instructionIndicators.remove(index);
        this.parameterCodes.remove(index);
    }

    public int getCode() {
        return 57;
    }
}

