/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.UserServiceInformation;

public class UserServiceInformationImpl
extends AbstractISUPParameter
implements UserServiceInformation {
    private int codingStandart = 0;
    private int informationTransferCapability = 0;
    private int transferMode = 0;
    private int customInformationTransferRate = 0;
    private int informationTransferRate = 0;
    private int l1UserInformation = 0;
    private int l2UserInformation = 0;
    private int l3UserInformation = 0;
    private int syncMode = 0;
    private int negotiation = 0;
    private int userRate = 0;
    private int intermediateRate = 0;
    private int nicOnTx = 0;
    private int nicOnRx = 0;
    private int fcOnTx = 0;
    private int fcOnRx = 0;
    private int hdr = 0;
    private int multiframe = 0;
    private int mode = 0;
    private int lli = 0;
    private int assignor = 0;
    private int inBandNegotiation = 0;
    private int stopBits = 0;
    private int dataBits = 0;
    private int parity = 0;
    private int duplexMode = 0;
    private int modemType = 0;
    private int l3Protocol = 0;

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2 || b.length > 13) {
            throw new IllegalArgumentException("byte[] must not be null and should be between 2 and 13 bytes in length");
        }
        int v = 0;
        int index = 0;
        int tempValue = 0;
        v = b[index++];
        this.informationTransferCapability = v & 0x1F;
        this.codingStandart = v >> 5 & 3;
        v = b[index++];
        this.informationTransferRate = v & 0x1F;
        this.transferMode = v >> 5 & 3;
        if (this.informationTransferRate == 24) {
            if (b.length < 3) {
                throw new IllegalArgumentException("byte[] should be at least 3 bytes in length");
            }
            this.customInformationTransferRate = v = b[index++];
        }
        block12: while (index < b.length) {
            v = b[index++];
            tempValue = v >> 5 & 3;
            switch (tempValue) {
                case 1: {
                    this.l1UserInformation = v & 0x1F;
                    if (this.informationTransferCapability == 8) {
                        switch (this.l1UserInformation) {
                            case 1: 
                            case 7: {
                                v = b[index++];
                                this.syncMode = v >> 6 & 1;
                                this.negotiation = v >> 5 & 1;
                                this.userRate = v & 0x1F;
                                if (this.syncMode != 0) break;
                                v = b[index++];
                                this.intermediateRate = v >> 5 & 3;
                                this.nicOnTx = v >> 4 & 1;
                                this.nicOnRx = v >> 3 & 1;
                                this.fcOnTx = v >> 2 & 1;
                                this.fcOnRx = v >> 1 & 1;
                                v = b[index++];
                                this.stopBits = v >> 5 & 3;
                                this.dataBits = v >> 3 & 3;
                                this.parity = v & 7;
                                v = b[index++];
                                this.duplexMode = v >> 6 & 1;
                                this.modemType = v & 0x1F;
                                break;
                            }
                            case 8: {
                                v = b[index++];
                                this.syncMode = v >> 6 & 1;
                                this.negotiation = v >> 5 & 1;
                                this.userRate = v & 0x1F;
                                if (this.syncMode != 0) break;
                                v = b[index++];
                                this.hdr = v >> 6 & 1;
                                this.multiframe = v >> 5 & 1;
                                this.mode = v >> 4 & 1;
                                this.lli = v >> 3 & 1;
                                this.assignor = v >> 2 & 1;
                                this.inBandNegotiation = v >> 1 & 1;
                                v = b[index++];
                                this.stopBits = v >> 5 & 3;
                                this.dataBits = v >> 3 & 3;
                                this.parity = v & 7;
                                v = b[index++];
                                this.duplexMode = v >> 6 & 1;
                                this.modemType = v & 0x1F;
                            }
                        }
                        continue block12;
                    }
                    if (this.informationTransferCapability != 16 || this.transferMode != 2) continue block12;
                    switch (this.l1UserInformation) {
                        case 2: 
                        case 3: {
                            v = b[index++];
                            this.syncMode = v >> 6 & 1;
                            this.negotiation = v >> 5 & 1;
                            this.userRate = v & 0x1F;
                            v = b[index++];
                            this.stopBits = v >> 5 & 3;
                            this.dataBits = v >> 3 & 3;
                            this.parity = v & 7;
                            v = b[index++];
                            this.duplexMode = v >> 6 & 1;
                            this.modemType = v & 0x1F;
                        }
                    }
                    continue block12;
                }
                case 2: {
                    this.l2UserInformation = v & 0x1F;
                    continue block12;
                }
                case 3: {
                    this.l3UserInformation = v & 0x1F;
                    if (this.l3UserInformation != 11) continue block12;
                    v = b[index++];
                    this.l3Protocol = (v & 0xF) << 4;
                    v = b[index++];
                    this.l3Protocol |= v & 0xF;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("invalid layer identifier");
        }
        return 0;
    }

    public byte[] encode() throws ParameterException {
        int byteLength = 2;
        if (this.transferMode == 24) {
            ++byteLength;
        }
        if (this.l1UserInformation > 0) {
            ++byteLength;
            switch (this.l1UserInformation) {
                case 1: 
                case 7: 
                case 8: {
                    if (this.informationTransferCapability != 8) break;
                    ++byteLength;
                    if (this.syncMode != 0) break;
                    byteLength += 3;
                    break;
                }
                case 2: 
                case 3: {
                    if (this.informationTransferCapability != 16 || this.transferMode != 2) break;
                    byteLength += 3;
                }
            }
        }
        if (this.l2UserInformation > 0) {
            ++byteLength;
        }
        if (this.l3UserInformation > 0) {
            ++byteLength;
            if (this.l3UserInformation == 11) {
                byteLength += 2;
            }
        }
        byte[] b = new byte[byteLength];
        b[0] = (byte)(b[0] | 0x80);
        b[0] = (byte)(b[0] | (this.codingStandart & 3) << 5);
        b[0] = (byte)(b[0] | this.informationTransferCapability & 0x1F);
        b[1] = (byte)(b[1] | 0x80);
        b[1] = (byte)(b[1] | (this.transferMode & 3) << 5);
        b[1] = (byte)(b[1] | this.informationTransferRate & 0x1F);
        byteLength = 2;
        if (this.transferMode == 24) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x80);
            int n2 = byteLength++;
            b[n2] = (byte)(b[n2] | this.customInformationTransferRate);
        }
        if (this.l1UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x20);
            int n3 = byteLength++;
            b[n3] = (byte)(b[n3] | this.l1UserInformation & 0x1F);
            switch (this.l1UserInformation) {
                case 1: 
                case 7: {
                    if (this.informationTransferCapability != 8) break;
                    int n4 = byteLength;
                    b[n4] = (byte)(b[n4] | this.syncMode << 6);
                    int n5 = byteLength;
                    b[n5] = (byte)(b[n5] | this.negotiation << 5);
                    int n6 = byteLength++;
                    b[n6] = (byte)(b[n6] | this.userRate);
                    if (this.syncMode != 0) break;
                    int n7 = byteLength;
                    b[n7] = (byte)(b[n7] | this.intermediateRate << 5);
                    int n8 = byteLength;
                    b[n8] = (byte)(b[n8] | this.nicOnTx << 4);
                    int n9 = byteLength;
                    b[n9] = (byte)(b[n9] | this.nicOnRx << 3);
                    int n10 = byteLength;
                    b[n10] = (byte)(b[n10] | this.fcOnTx << 2);
                    int n11 = byteLength++;
                    b[n11] = (byte)(b[n11] | this.fcOnRx << 1);
                    int n12 = byteLength;
                    b[n12] = (byte)(b[n12] | this.stopBits << 5);
                    int n13 = byteLength;
                    b[n13] = (byte)(b[n13] | this.dataBits << 3);
                    int n14 = byteLength++;
                    b[n14] = (byte)(b[n14] | this.parity);
                    int n15 = byteLength;
                    b[n15] = (byte)(b[n15] | 0x80);
                    int n16 = byteLength;
                    b[n16] = (byte)(b[n16] | this.duplexMode << 6);
                    int n17 = byteLength++;
                    b[n17] = (byte)(b[n17] | this.modemType);
                    break;
                }
                case 8: {
                    if (this.informationTransferCapability != 8) break;
                    int n18 = byteLength;
                    b[n18] = (byte)(b[n18] | this.syncMode << 6);
                    int n19 = byteLength;
                    b[n19] = (byte)(b[n19] | this.negotiation << 5);
                    int n20 = byteLength++;
                    b[n20] = (byte)(b[n20] | this.userRate);
                    if (this.syncMode != 0) break;
                    int n21 = byteLength;
                    b[n21] = (byte)(b[n21] | this.hdr << 6);
                    int n22 = byteLength;
                    b[n22] = (byte)(b[n22] | this.multiframe << 5);
                    int n23 = byteLength;
                    b[n23] = (byte)(b[n23] | this.mode << 4);
                    int n24 = byteLength;
                    b[n24] = (byte)(b[n24] | this.lli << 3);
                    int n25 = byteLength;
                    b[n25] = (byte)(b[n25] | this.assignor << 3);
                    int n26 = byteLength++;
                    b[n26] = (byte)(b[n26] | this.inBandNegotiation << 1);
                    int n27 = byteLength;
                    b[n27] = (byte)(b[n27] | this.stopBits << 5);
                    int n28 = byteLength;
                    b[n28] = (byte)(b[n28] | this.dataBits << 3);
                    int n29 = byteLength++;
                    b[n29] = (byte)(b[n29] | this.parity);
                    int n30 = byteLength;
                    b[n30] = (byte)(b[n30] | 0x80);
                    int n31 = byteLength;
                    b[n31] = (byte)(b[n31] | this.duplexMode << 6);
                    int n32 = byteLength++;
                    b[n32] = (byte)(b[n32] | this.modemType);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.informationTransferCapability != 16 || this.transferMode != 2) break;
                    int n33 = byteLength;
                    b[n33] = (byte)(b[n33] | this.syncMode << 6);
                    int n34 = byteLength;
                    b[n34] = (byte)(b[n34] | this.negotiation << 5);
                    int n35 = byteLength++;
                    b[n35] = (byte)(b[n35] | this.userRate);
                    int n36 = byteLength;
                    b[n36] = (byte)(b[n36] | this.stopBits << 5);
                    int n37 = byteLength;
                    b[n37] = (byte)(b[n37] | this.dataBits << 3);
                    int n38 = byteLength++;
                    b[n38] = (byte)(b[n38] | this.parity);
                    int n39 = byteLength;
                    b[n39] = (byte)(b[n39] | 0x80);
                    int n40 = byteLength;
                    b[n40] = (byte)(b[n40] | this.duplexMode << 6);
                    int n41 = byteLength++;
                    b[n41] = (byte)(b[n41] | this.modemType);
                }
            }
        }
        if (this.l2UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x80);
            int n42 = byteLength;
            b[n42] = (byte)(b[n42] | 0x40);
            int n43 = byteLength++;
            b[n43] = (byte)(b[n43] | this.l2UserInformation & 0x1F);
        }
        if (this.l3UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x60);
            int n44 = byteLength++;
            b[n44] = (byte)(b[n44] | this.l3UserInformation & 0x1F);
            if (this.l3UserInformation == 11) {
                int n45 = byteLength;
                b[n45] = (byte)(b[n45] | 0x80);
                int n46 = byteLength++;
                b[n46] = (byte)(b[n46] | this.l3Protocol >> 4 & 0xF);
                int n47 = byteLength++;
                b[n47] = (byte)(b[n47] | this.l3Protocol & 0xF);
            }
        }
        return b;
    }

    public int getCode() {
        return 29;
    }

    public UserServiceInformationImpl() {
    }

    public UserServiceInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int getCodingStandart() {
        return this.codingStandart;
    }

    public void setCodingStandart(int codingStandart) {
        this.codingStandart = codingStandart;
    }

    public int getInformationTransferCapability() {
        return this.informationTransferCapability;
    }

    public void setInformationTransferCapability(int informationTransferCapability) {
        this.informationTransferCapability = informationTransferCapability;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(int transferMode) {
        this.transferMode = transferMode;
    }

    public int getInformationTransferRate() {
        return this.informationTransferRate;
    }

    public void setInformationTransferRate(int informationTransferRate) {
        this.informationTransferRate = informationTransferRate;
    }

    public int getCustomInformationTransferRate() {
        return this.customInformationTransferRate;
    }

    public void setCustomInformationTransferRate(int customInformationTransferRate) {
        this.customInformationTransferRate = customInformationTransferRate;
    }

    public int getL1UserInformation() {
        return this.l1UserInformation;
    }

    public void setL1UserInformation(int l1UserInformation) {
        this.l1UserInformation = l1UserInformation;
    }

    public int getL2UserInformation() {
        return this.l2UserInformation;
    }

    public void setL2UserInformation(int l2UserInformation) {
        this.l2UserInformation = l2UserInformation;
    }

    public int getL3UserInformation() {
        return this.l3UserInformation;
    }

    public void setL3UserInformation(int l3UserInformation) {
        this.l3UserInformation = l3UserInformation;
    }

    public int getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(int syncMode) {
        this.syncMode = syncMode;
    }

    public int getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(int negotiation) {
        this.negotiation = negotiation;
    }

    public int getUserRate() {
        return this.userRate;
    }

    public void setUserRate(int userRate) {
        this.userRate = userRate;
    }

    public int getIntermediateRate() {
        return this.intermediateRate;
    }

    public void setIntermediateRate(int intermediateRate) {
        this.intermediateRate = intermediateRate;
    }

    public int getNicOnTx() {
        return this.nicOnTx;
    }

    public void setNicOnTx(int nicOnTx) {
        this.nicOnTx = nicOnTx;
    }

    public int getNicOnRx() {
        return this.nicOnRx;
    }

    public void setNicOnRx(int nicOnRx) {
        this.nicOnRx = nicOnRx;
    }

    public int getFlowControlOnTx() {
        return this.fcOnTx;
    }

    public void setFlowControlOnTx(int fcOnTx) {
        this.fcOnTx = fcOnTx;
    }

    public int getFlowControlOnRx() {
        return this.fcOnRx;
    }

    public void setFlowControlOnRx(int fcOnRx) {
        this.fcOnRx = fcOnRx;
    }

    public int getHDR() {
        return this.hdr;
    }

    public void setHDR(int hdr) {
        this.hdr = hdr;
    }

    public int getMultiframe() {
        return this.multiframe;
    }

    public void setMultiframe(int multiframe) {
        this.multiframe = multiframe;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getLLINegotiation() {
        return this.lli;
    }

    public void setLLINegotiation(int lli) {
        this.lli = lli;
    }

    public int getAssignor() {
        return this.assignor;
    }

    public void setAssignor(int assignor) {
        this.assignor = assignor;
    }

    public int getInBandNegotiation() {
        return this.inBandNegotiation;
    }

    public void setInBandNegotiation(int inBandNegotiation) {
        this.inBandNegotiation = inBandNegotiation;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public int getDuplexMode() {
        return this.duplexMode;
    }

    public void setDuplexMode(int duplexMode) {
        this.duplexMode = duplexMode;
    }

    public int getModemType() {
        return this.modemType;
    }

    public void setModemType(int modemType) {
        this.modemType = modemType;
    }

    public int getL3Protocol() {
        return this.l3Protocol;
    }

    public void setL3Protocol(int l3Protocol) {
        this.l3Protocol = l3Protocol;
    }
}

