/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.UserTeleserviceInformation;

public class UserTeleserviceInformationImpl
extends AbstractISUPParameter
implements UserTeleserviceInformation {
    private int codingStandard;
    private int interpretation;
    private int presentationMethod;
    private int highLayerCharIdentification;
    private boolean eHighLayerCharIdentificationPresent;
    private boolean eVidedoTelephonyCharIdentificationPresent;
    private int eHighLayerCharIdentification;
    private int eVidedoTelephonyCharIdentification;

    public UserTeleserviceInformationImpl() {
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification, int eVidedoTelephonyCharIdentification, boolean notImportantIgnoredParameter) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
        this.setEVidedoTelephonyCharIdentification(eVidedoTelephonyCharIdentification);
    }

    public UserTeleserviceInformationImpl(int codingStandard, int interpretation, int presentationMethod, int highLayerCharIdentification, int eHighLayerCharIdentification) {
        this.setCodingStandard(codingStandard);
        this.setInterpretation(interpretation);
        this.setPresentationMethod(presentationMethod);
        this.setHighLayerCharIdentification(highLayerCharIdentification);
        this.setEHighLayerCharIdentification(eHighLayerCharIdentification);
    }

    public UserTeleserviceInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int decode(byte[] b) throws ParameterException {
        boolean ext;
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must not be null and length must be greater than  1");
        }
        try {
            this.setPresentationMethod(b[0]);
            this.setInterpretation(b[0] >> 2);
            this.setCodingStandard(b[0] >> 5);
            this.setHighLayerCharIdentification(b[1]);
        }
        catch (Exception e) {
            throw new ParameterException((Throwable)e);
        }
        boolean bl = ext = (b[1] >> 7 & 1) == 0;
        if (ext && b.length != 3) {
            throw new ParameterException("byte[] indicates extension to high layer cahracteristic indicator, however there isnt enough bytes");
        }
        if (!ext) {
            return b.length;
        }
        if (this.highLayerCharIdentification == 94 || this.highLayerCharIdentification == 95) {
            this.setEHighLayerCharIdentification(b[2] & 0x7F);
        } else if (this.highLayerCharIdentification >= 99 && this.highLayerCharIdentification <= 103 || this.highLayerCharIdentification >= 105 && this.highLayerCharIdentification <= 111) {
            this.setEVidedoTelephonyCharIdentification(b[2] & 0x7F);
        }
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = null;
        b = this.eHighLayerCharIdentificationPresent || this.eVidedoTelephonyCharIdentificationPresent ? new byte[3] : new byte[2];
        int v = 0;
        v = this.presentationMethod & 3;
        v |= (this.interpretation & 7) << 2;
        v |= (this.codingStandard & 3) << 5;
        b[0] = (byte)(v |= 0x80);
        b[1] = (byte)(this.highLayerCharIdentification & 0x7F);
        if (this.eHighLayerCharIdentificationPresent || this.eVidedoTelephonyCharIdentificationPresent) {
            b[2] = this.eHighLayerCharIdentificationPresent ? (byte)(0x80 | this.eHighLayerCharIdentification & 0x7F) : (byte)(0x80 | this.eVidedoTelephonyCharIdentification & 0x7F);
            return b;
        }
        b[1] = (byte)(b[1] | 0x80);
        return b;
    }

    public int getCodingStandard() {
        return this.codingStandard;
    }

    public void setCodingStandard(int codingStandard) {
        this.codingStandard = codingStandard & 3;
    }

    public int getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(int interpretation) {
        this.interpretation = interpretation & 7;
    }

    public int getPresentationMethod() {
        return this.presentationMethod;
    }

    public void setPresentationMethod(int presentationMethod) {
        this.presentationMethod = presentationMethod & 3;
    }

    public int getHighLayerCharIdentification() {
        return this.highLayerCharIdentification;
    }

    public void setHighLayerCharIdentification(int highLayerCharIdentification) {
        this.highLayerCharIdentification = highLayerCharIdentification & 0x7F;
    }

    public int getEHighLayerCharIdentification() {
        return this.eHighLayerCharIdentification;
    }

    public void setEHighLayerCharIdentification(int highLayerCharIdentification) {
        if (this.eVidedoTelephonyCharIdentificationPresent) {
            throw new IllegalStateException("Either Extended VideoTlephony or Extended HighLayer octet is set. ExtendedVideoTlephony is already present");
        }
        if (this.highLayerCharIdentification != 94 && this.highLayerCharIdentification != 95) {
            throw new IllegalArgumentException("Can not set this octet - HLCI is of value: " + this.highLayerCharIdentification);
        }
        this.eHighLayerCharIdentificationPresent = true;
        this.eHighLayerCharIdentification = highLayerCharIdentification & 0x7F;
    }

    public int getEVidedoTelephonyCharIdentification() {
        return this.eVidedoTelephonyCharIdentification;
    }

    public void setEVidedoTelephonyCharIdentification(int eVidedoTelephonyCharIdentification) {
        if (this.eHighLayerCharIdentificationPresent) {
            throw new IllegalStateException("Either Extended VideoTlephony or Extended HighLayer octet is set. ExtendedHighLayer is already present");
        }
        if (!(this.highLayerCharIdentification >= 99 && this.highLayerCharIdentification <= 103 || this.highLayerCharIdentification >= 105 && this.highLayerCharIdentification <= 111)) {
            throw new IllegalArgumentException("Can not set this octet - HLCI is of value: " + this.highLayerCharIdentification);
        }
        this.eVidedoTelephonyCharIdentificationPresent = true;
        this.eVidedoTelephonyCharIdentification = eVidedoTelephonyCharIdentification & 0x7F;
    }

    public boolean isEHighLayerCharIdentificationPresent() {
        return this.eHighLayerCharIdentificationPresent;
    }

    public boolean isEVidedoTelephonyCharIdentificationPresent() {
        return this.eVidedoTelephonyCharIdentificationPresent;
    }

    public int getCode() {
        return 52;
    }
}

