/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.UserToUserIndicators;

public class UserToUserIndicatorsImpl
extends AbstractISUPParameter
implements UserToUserIndicators {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private boolean response;
    private int serviceOne;
    private int serviceTwo;
    private int serviceThree;
    private boolean networkDiscardIndicator;

    public UserToUserIndicatorsImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public UserToUserIndicatorsImpl() {
    }

    public UserToUserIndicatorsImpl(boolean response, int serviceOne, int serviceTwo, int serviceThree, boolean networkDiscardIndicator) {
        this.response = response;
        this.serviceOne = serviceOne;
        this.serviceTwo = serviceTwo;
        this.serviceThree = serviceThree;
        this.networkDiscardIndicator = networkDiscardIndicator;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 1) {
            throw new ParameterException("byte[] must  not be null and length must  be 1");
        }
        try {
            this.setResponse((b[0] & 1) == 1);
            this.setServiceOne(b[0] >> 1);
            this.setServiceTwo(b[0] >> 3);
            this.setServiceThree(b[0] >> 5);
            this.setNetworkDiscardIndicator((b[0] >> 7 & 1) == 1);
        }
        catch (Exception e) {
            throw new ParameterException((Throwable)e);
        }
        return 1;
    }

    public byte[] encode() throws ParameterException {
        int v = this.response ? 1 : 0;
        v |= (this.serviceOne & 3) << 1;
        v |= (this.serviceTwo & 3) << 3;
        v |= (this.serviceThree & 3) << 5;
        return new byte[]{(byte)(v |= (this.networkDiscardIndicator ? 1 : 0) << 7)};
    }

    public boolean isResponse() {
        return this.response;
    }

    public void setResponse(boolean response) {
        this.response = response;
    }

    public int getServiceOne() {
        return this.serviceOne;
    }

    public void setServiceOne(int serviceOne) {
        this.serviceOne = serviceOne & 3;
    }

    public int getServiceTwo() {
        return this.serviceTwo;
    }

    public void setServiceTwo(int serviceTwo) {
        this.serviceTwo = serviceTwo & 3;
    }

    public int getServiceThree() {
        return this.serviceThree;
    }

    public void setServiceThree(int serviceThree) {
        this.serviceThree = serviceThree & 3;
    }

    public boolean isNetworkDiscardIndicator() {
        return this.networkDiscardIndicator;
    }

    public void setNetworkDiscardIndicator(boolean networkDiscardIndicator) {
        this.networkDiscardIndicator = networkDiscardIndicator;
    }

    public int getCode() {
        return 42;
    }
}

