/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationListener;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.PayloadData;
import org.mobicents.protocols.ss7.m3ua.Asp;
import org.mobicents.protocols.ss7.m3ua.AspFactory;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryStopTimer;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspStateMaintenanceHandler;
import org.mobicents.protocols.ss7.m3ua.impl.AspTrafficMaintenanceHandler;
import org.mobicents.protocols.ss7.m3ua.impl.HeartBeatTimer;
import org.mobicents.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.mobicents.protocols.ss7.m3ua.impl.ManagementMessageHandler;
import org.mobicents.protocols.ss7.m3ua.impl.RoutingKeyManagementHandler;
import org.mobicents.protocols.ss7.m3ua.impl.SignalingNetworkManagementHandler;
import org.mobicents.protocols.ss7.m3ua.impl.TransferMessageHandler;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.mobicents.protocols.ss7.m3ua.impl.message.M3UAMessageImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.message.M3UAMessage;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPDown;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPDownAck;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPUp;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPUpAck;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.Heartbeat;
import org.mobicents.protocols.ss7.m3ua.message.asptm.ASPActive;
import org.mobicents.protocols.ss7.m3ua.message.asptm.ASPActiveAck;
import org.mobicents.protocols.ss7.m3ua.message.asptm.ASPInactive;
import org.mobicents.protocols.ss7.m3ua.message.asptm.ASPInactiveAck;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Error;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationAvailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationRestricted;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationStateAudit;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationUPUnavailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationUnavailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.SignallingCongestion;
import org.mobicents.protocols.ss7.m3ua.parameter.ASPIdentifier;
import org.mobicents.protocols.ss7.m3ua.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.mtp.Mtp3EndCongestionPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusCause;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;

public class AspFactoryImpl
implements AssociationListener,
XMLSerializable,
AspFactory {
    private static final Logger logger = Logger.getLogger(AspFactoryImpl.class);
    private static long ASP_ID_COUNT = 1L;
    private static final int SCTP_PAYLOAD_PROT_ID_M3UA = 3;
    private static final String NAME = "name";
    private static final String STARTED = "started";
    private static final String ASSOCIATION_NAME = "assocName";
    private static final String MAX_SEQUENCE_NUMBER = "maxseqnumber";
    private static final String ASP_ID = "aspid";
    private static final String HEART_BEAT = "heartbeat";
    protected String name;
    protected boolean started = false;
    protected Association association = null;
    protected String associationName = null;
    protected FastList<Asp> aspList = new FastList();
    private ByteBuffer txBuffer = ByteBuffer.allocateDirect(8192);
    private CompositeByteBuf tcpIncBuffer;
    protected Management transportManagement = null;
    protected M3UAManagementImpl m3UAManagementImpl = null;
    private ASPIdentifier aspid;
    protected ParameterFactory parameterFactory = new ParameterFactoryImpl();
    protected MessageFactory messageFactory = new MessageFactoryImpl();
    private TransferMessageHandler transferMessageHandler = new TransferMessageHandler(this);
    private SignalingNetworkManagementHandler signalingNetworkManagementHandler = new SignalingNetworkManagementHandler(this);
    private ManagementMessageHandler managementMessageHandler = new ManagementMessageHandler(this);
    private AspStateMaintenanceHandler aspStateMaintenanceHandler = new AspStateMaintenanceHandler(this);
    private AspTrafficMaintenanceHandler aspTrafficMaintenanceHandler = new AspTrafficMaintenanceHandler(this);
    private RoutingKeyManagementHandler routingKeyManagementHandler = new RoutingKeyManagementHandler(this);
    protected Functionality functionality = null;
    protected IPSPType ipspType = null;
    protected ExchangeType exchangeType = null;
    private long aspupSentTime = 0L;
    private int maxSequenceNumber = 256;
    private int[] slsTable = null;
    private int maxOutboundStreams;
    protected AspFactoryStopTimer aspFactoryStopTimer = null;
    protected HeartBeatTimer heartBeatTimer = null;
    private boolean isHeartBeatEnabled = false;
    private FastMap<Integer, AtomicInteger> congDpcList = new FastMap().shared();
    protected static final XMLFormat<AspFactoryImpl> ASP_FACTORY_XML = new XMLFormat<AspFactoryImpl>(AspFactoryImpl.class){

        public void read(XMLFormat.InputElement xml, AspFactoryImpl aspFactoryImpl) throws XMLStreamException {
            aspFactoryImpl.name = xml.getAttribute(AspFactoryImpl.NAME, "");
            aspFactoryImpl.associationName = xml.getAttribute(AspFactoryImpl.ASSOCIATION_NAME, "");
            aspFactoryImpl.started = xml.getAttribute(AspFactoryImpl.STARTED).toBoolean();
            aspFactoryImpl.maxSequenceNumber = xml.getAttribute(AspFactoryImpl.MAX_SEQUENCE_NUMBER, 256);
            AspFactoryImpl.access$102(aspFactoryImpl, new int[aspFactoryImpl.maxSequenceNumber]);
            long aspIdTemp = xml.getAttribute(AspFactoryImpl.ASP_ID, aspFactoryImpl.generateId());
            aspFactoryImpl.aspid = aspFactoryImpl.parameterFactory.createASPIdentifier(aspIdTemp);
            aspFactoryImpl.isHeartBeatEnabled = xml.getAttribute(AspFactoryImpl.HEART_BEAT, false);
        }

        public void write(AspFactoryImpl aspFactoryImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AspFactoryImpl.NAME, aspFactoryImpl.name);
            xml.setAttribute(AspFactoryImpl.ASSOCIATION_NAME, aspFactoryImpl.associationName);
            xml.setAttribute(AspFactoryImpl.STARTED, aspFactoryImpl.started);
            xml.setAttribute(AspFactoryImpl.MAX_SEQUENCE_NUMBER, aspFactoryImpl.maxSequenceNumber);
            xml.setAttribute(AspFactoryImpl.ASP_ID, aspFactoryImpl.aspid.getAspId());
            xml.setAttribute(AspFactoryImpl.HEART_BEAT, aspFactoryImpl.isHeartBeatEnabled);
        }
    };

    public AspFactoryImpl() {
        this.txBuffer.clear();
        this.txBuffer.rewind();
        this.txBuffer.flip();
        this.heartBeatTimer = new HeartBeatTimer(this);
    }

    public AspFactoryImpl(String name, int maxSequenceNumber, long aspId, boolean isHeartBeatEnabled) {
        this();
        this.name = name;
        this.maxSequenceNumber = maxSequenceNumber;
        this.slsTable = new int[this.maxSequenceNumber];
        this.aspid = this.parameterFactory.createASPIdentifier(aspId);
        this.isHeartBeatEnabled = isHeartBeatEnabled;
    }

    public ASPIdentifier getAspid() {
        return this.aspid;
    }

    public boolean isHeartBeatEnabled() {
        return this.isHeartBeatEnabled;
    }

    public void setM3UAManagement(M3UAManagementImpl m3uaManagement) {
        this.m3UAManagementImpl = m3uaManagement;
        this.transferMessageHandler.setM3UAManagement(m3uaManagement);
    }

    public M3UAManagementImpl getM3UAManagement() {
        return this.m3UAManagementImpl;
    }

    protected void start() throws Exception {
        this.transportManagement.startAssociation(this.association.getName());
        this.started = true;
    }

    protected void stop() throws Exception {
        this.started = false;
        if (this.association == null) {
            return;
        }
        if (this.isHeartBeatEnabled()) {
            this.heartBeatTimer.cancel();
        }
        if (this.functionality == Functionality.AS || this.functionality == Functionality.SGW && this.exchangeType == ExchangeType.DE || this.functionality == Functionality.IPSP && this.exchangeType == ExchangeType.DE || this.functionality == Functionality.IPSP && this.exchangeType == ExchangeType.SE && this.ipspType == IPSPType.CLIENT) {
            if (this.association.isConnected()) {
                ASPDown aspDown = (ASPDown)this.messageFactory.createMessage(3, 2);
                this.write((M3UAMessage)aspDown);
                FastList.Node n = this.aspList.head();
                FastList.Node end = this.aspList.tail();
                while ((n = n.getNext()) != end) {
                    AspImpl aspImpl = (AspImpl)n.getValue();
                    try {
                        FSM aspLocalFSM = aspImpl.getLocalFSM();
                        aspLocalFSM.signal("aspdownsent");
                        AsImpl peerAs = (AsImpl)aspImpl.getAs();
                        FSM asPeerFSM = peerAs.getPeerFSM();
                        asPeerFSM.setAttribute("asp", aspImpl);
                        asPeerFSM.signal("aspdown");
                    }
                    catch (UnknownTransitionException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.aspFactoryStopTimer = new AspFactoryStopTimer(this);
                this.m3UAManagementImpl.m3uaScheduler.execute(this.aspFactoryStopTimer);
            } else {
                FastList.Node n = this.aspList.head();
                FastList.Node end = this.aspList.tail();
                while ((n = n.getNext()) != end) {
                    AspImpl aspImpl = (AspImpl)n.getValue();
                    try {
                        FSM aspLocalFSM = aspImpl.getLocalFSM();
                        aspLocalFSM.signal("commdown");
                        AsImpl peerAs = (AsImpl)aspImpl.getAs();
                        FSM asPeerFSM = peerAs.getPeerFSM();
                        asPeerFSM.setAttribute("asp", aspImpl);
                        asPeerFSM.signal("aspdown");
                    }
                    catch (UnknownTransitionException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.transportManagement.stopAssociation(this.association.getName());
            }
        } else {
            this.transportManagement.stopAssociation(this.association.getName());
        }
    }

    public boolean getStatus() {
        return this.started;
    }

    public Functionality getFunctionality() {
        return this.functionality;
    }

    protected void setFunctionality(Functionality functionality) {
        this.functionality = functionality;
    }

    public IPSPType getIpspType() {
        return this.ipspType;
    }

    protected void setIpspType(IPSPType ipspType) {
        this.ipspType = ipspType;
    }

    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    protected void setExchangeType(ExchangeType exchangeType) {
        this.exchangeType = exchangeType;
    }

    protected void setTransportManagement(Management transportManagement) {
        this.transportManagement = transportManagement;
    }

    public Association getAssociation() {
        return this.association;
    }

    protected void setAssociation(Association association) {
        if (this.association != null) {
            this.association.setAssociationListener(null);
        }
        this.association = association;
        this.associationName = this.association.getName();
        this.association.setAssociationListener((AssociationListener)this);
    }

    protected void unsetAssociation() throws Exception {
        if (this.association != null) {
            if (this.association.isStarted()) {
                throw new Exception(String.format("Association=%s is still started. Stop first", this.association.getName()));
            }
            this.association.setAssociationListener(null);
            this.association = null;
        }
    }

    public String getName() {
        return this.name;
    }

    protected void read(M3UAMessage message) {
        block0 : switch (message.getMessageClass()) {
            case 0: {
                switch (message.getMessageType()) {
                    case 0: {
                        this.managementMessageHandler.handleError((Error)message);
                        break block0;
                    }
                    case 1: {
                        Notify notify = (Notify)message;
                        this.managementMessageHandler.handleNotify(notify);
                        break block0;
                    }
                }
                logger.error((Object)String.format("Rx : MGMT with invalid MessageType=%d message=%s", message.getMessageType(), message));
                break;
            }
            case 1: {
                switch (message.getMessageType()) {
                    case 1: {
                        org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData payload = (org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData)message;
                        this.transferMessageHandler.handlePayload(payload);
                        break block0;
                    }
                }
                logger.error((Object)String.format("Rx : Transfer message with invalid MessageType=%d message=%s", message.getMessageType(), message));
                break;
            }
            case 2: {
                switch (message.getMessageType()) {
                    case 1: {
                        DestinationUnavailable duna = (DestinationUnavailable)message;
                        this.signalingNetworkManagementHandler.handleDestinationUnavailable(duna);
                        break block0;
                    }
                    case 2: {
                        DestinationAvailable dava = (DestinationAvailable)message;
                        this.signalingNetworkManagementHandler.handleDestinationAvailable(dava);
                        break block0;
                    }
                    case 3: {
                        DestinationStateAudit daud = (DestinationStateAudit)message;
                        this.signalingNetworkManagementHandler.handleDestinationStateAudit(daud);
                        break block0;
                    }
                    case 4: {
                        SignallingCongestion scon = (SignallingCongestion)message;
                        this.signalingNetworkManagementHandler.handleSignallingCongestion(scon);
                        break block0;
                    }
                    case 5: {
                        DestinationUPUnavailable dupu = (DestinationUPUnavailable)message;
                        this.signalingNetworkManagementHandler.handleDestinationUPUnavailable(dupu);
                        break block0;
                    }
                    case 6: {
                        DestinationRestricted drst = (DestinationRestricted)message;
                        this.signalingNetworkManagementHandler.handleDestinationRestricted(drst);
                        break block0;
                    }
                }
                logger.error((Object)String.format("Received SSNM with invalid MessageType=%d message=%s", message.getMessageType(), message));
                break;
            }
            case 3: {
                switch (message.getMessageType()) {
                    case 1: {
                        ASPUp aspUp = (ASPUp)message;
                        this.aspStateMaintenanceHandler.handleAspUp(aspUp);
                        break block0;
                    }
                    case 4: {
                        ASPUpAck aspUpAck = (ASPUpAck)message;
                        this.aspStateMaintenanceHandler.handleAspUpAck(aspUpAck);
                        break block0;
                    }
                    case 2: {
                        ASPDown aspDown = (ASPDown)message;
                        this.aspStateMaintenanceHandler.handleAspDown(aspDown);
                        break block0;
                    }
                    case 5: {
                        ASPDownAck aspDownAck = (ASPDownAck)message;
                        this.aspStateMaintenanceHandler.handleAspDownAck(aspDownAck);
                        break block0;
                    }
                    case 3: {
                        Heartbeat hrtBeat = (Heartbeat)message;
                        this.aspStateMaintenanceHandler.handleHeartbeat(hrtBeat);
                        break block0;
                    }
                    case 6: {
                        break block0;
                    }
                }
                logger.error((Object)String.format("Received ASPSM with invalid MessageType=%d message=%s", message.getMessageType(), message));
                break;
            }
            case 4: {
                switch (message.getMessageType()) {
                    case 1: {
                        ASPActive aspActive = (ASPActive)message;
                        this.aspTrafficMaintenanceHandler.handleAspActive(aspActive);
                        break block0;
                    }
                    case 3: {
                        ASPActiveAck aspAciveAck = (ASPActiveAck)message;
                        this.aspTrafficMaintenanceHandler.handleAspActiveAck(aspAciveAck);
                        break block0;
                    }
                    case 2: {
                        ASPInactive aspInactive = (ASPInactive)message;
                        this.aspTrafficMaintenanceHandler.handleAspInactive(aspInactive);
                        break block0;
                    }
                    case 4: {
                        ASPInactiveAck aspInaciveAck = (ASPInactiveAck)message;
                        this.aspTrafficMaintenanceHandler.handleAspInactiveAck(aspInaciveAck);
                        break block0;
                    }
                }
                logger.error((Object)String.format("Received ASPTM with invalid MessageType=%d message=%s", message.getMessageType(), message));
                break;
            }
            case 9: {
                break;
            }
            default: {
                logger.error((Object)String.format("Received message with invalid MessageClass=%d message=%s", message.getMessageClass(), message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(M3UAMessage message) {
        block17: {
            try {
                ByteBufAllocator byteBufAllocator = this.association.getByteBufAllocator();
                ByteBuf byteBuf = byteBufAllocator != null ? byteBufAllocator.buffer() : Unpooled.buffer();
                ((M3UAMessageImpl)message).encode(byteBuf);
                PayloadData payloadData = null;
                if (this.m3UAManagementImpl.isSctpLibNettySupport()) {
                    switch (message.getMessageClass()) {
                        case 0: 
                        case 3: 
                        case 9: {
                            payloadData = new PayloadData(byteBuf.readableBytes(), byteBuf, true, true, 3, 0);
                            break;
                        }
                        case 1: {
                            org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData payload = (org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData)message;
                            int seqControl = payload.getData().getSLS();
                            payloadData = new PayloadData(byteBuf.readableBytes(), byteBuf, true, false, 3, this.slsTable[seqControl]);
                            break;
                        }
                        default: {
                            payloadData = new PayloadData(byteBuf.readableBytes(), byteBuf, true, true, 3, 0);
                        }
                    }
                    this.association.send(payloadData);
                    int congLevel = this.association.getCongestionLevel();
                    if (message instanceof org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData) {
                        org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData payloadData2 = (org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData)message;
                        if (congLevel > 0) {
                            this.sendCongestionInfoToMtp3Users(congLevel, payloadData2.getData().getDpc());
                        } else {
                            this.sendCongestionEndInfoToMtp3Users(congLevel, payloadData2.getData().getDpc());
                        }
                    }
                    break block17;
                }
                byte[] bf = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bf);
                ByteBuffer byteBuffer = this.txBuffer;
                synchronized (byteBuffer) {
                    switch (message.getMessageClass()) {
                        case 0: 
                        case 3: 
                        case 9: {
                            payloadData = new PayloadData(byteBuf.readableBytes(), bf, true, true, 3, 0);
                            break;
                        }
                        case 1: {
                            org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData payload = (org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData)message;
                            int seqControl = payload.getData().getSLS();
                            payloadData = new PayloadData(byteBuf.readableBytes(), bf, true, false, 3, this.slsTable[seqControl]);
                            break;
                        }
                        default: {
                            payloadData = new PayloadData(byteBuf.readableBytes(), bf, true, true, 3, 0);
                        }
                    }
                    this.association.send(payloadData);
                }
            }
            catch (Throwable e) {
                logger.error((Object)String.format("Error while trying to send PayloadData to SCTP layer. M3UAMessage=%s", message), e);
            }
        }
    }

    private void sendCongestionInfoToMtp3Users(int congLevel, int dpc) {
        AtomicInteger ai = (AtomicInteger)this.congDpcList.get((Object)dpc);
        if (ai == null) {
            ai = new AtomicInteger();
            this.congDpcList.put((Object)dpc, (Object)ai);
        }
        if (ai.incrementAndGet() % 8 == 0) {
            Mtp3StatusPrimitive statusPrimitive = new Mtp3StatusPrimitive(dpc, Mtp3StatusCause.SignallingNetworkCongested, congLevel, 0);
            this.m3UAManagementImpl.sendStatusMessageToLocalUser(statusPrimitive);
        }
    }

    private void sendCongestionEndInfoToMtp3Users(int congLevel, int dpc) {
        AtomicInteger ai = (AtomicInteger)this.congDpcList.get((Object)dpc);
        if (ai == null) {
            return;
        }
        ai = new AtomicInteger();
        this.congDpcList.remove((Object)dpc);
        Mtp3EndCongestionPrimitive endCongestionPrimitive = new Mtp3EndCongestionPrimitive(dpc);
        this.m3UAManagementImpl.sendEndCongestionMessageToLocalUser(endCongestionPrimitive);
    }

    protected AspImpl createAsp() {
        AspImpl remAsp = new AspImpl(this.name, this);
        if (this.getFunctionality() == Functionality.AS || this.getFunctionality() == Functionality.IPSP && this.getIpspType() == IPSPType.CLIENT) {
            remAsp.setASPIdentifier(this.aspid);
        }
        this.aspList.add((Object)remAsp);
        return remAsp;
    }

    protected boolean destroyAsp(AspImpl aspImpl) {
        aspImpl.aspFactoryImpl = null;
        return this.aspList.remove((Object)aspImpl);
    }

    public List<Asp> getAspList() {
        return this.aspList.unmodifiable();
    }

    protected AspImpl getAsp(long rc) {
        FastList.Node n = this.aspList.head();
        FastList.Node end = this.aspList.tail();
        while ((n = n.getNext()) != end) {
            Asp aspImpl = (Asp)n.getValue();
            if (aspImpl.getAs().getRoutingContext() == null || aspImpl.getAs().getRoutingContext().getRoutingContexts()[0] != rc) continue;
            return (AspImpl)aspImpl;
        }
        return null;
    }

    protected void sendAspActive(AsImpl asImpl) {
        ASPActive aspActive = (ASPActive)this.messageFactory.createMessage(4, 1);
        aspActive.setRoutingContext(asImpl.getRoutingContext());
        aspActive.setTrafficModeType(asImpl.getTrafficModeType());
        this.write((M3UAMessage)aspActive);
    }

    protected static long generateId() {
        if (++ASP_ID_COUNT == 0xFFFFFFFFL) {
            ASP_ID_COUNT = 1L;
        }
        return ASP_ID_COUNT;
    }

    private void handleCommDown() {
        if (this.isHeartBeatEnabled()) {
            this.heartBeatTimer.cancel();
        }
        FastList.Node n = this.aspList.head();
        FastList.Node end = this.aspList.tail();
        while ((n = n.getNext()) != end) {
            AspImpl aspImpl = (AspImpl)n.getValue();
            try {
                FSM asPeerFSM;
                AsImpl asImpl;
                FSM asLocalFSM;
                FSM aspPeerFSM;
                FSM aspLocalFSM = aspImpl.getLocalFSM();
                if (aspLocalFSM != null) {
                    aspLocalFSM.signal("commdown");
                }
                if ((aspPeerFSM = aspImpl.getPeerFSM()) != null) {
                    aspPeerFSM.signal("commdown");
                }
                if ((asLocalFSM = (asImpl = (AsImpl)aspImpl.getAs()).getLocalFSM()) != null) {
                    asLocalFSM.setAttribute("asp", aspImpl);
                    asLocalFSM.signal("aspdown");
                }
                if ((asPeerFSM = asImpl.getPeerFSM()) == null) continue;
                asPeerFSM.setAttribute("asp", aspImpl);
                asPeerFSM.signal("aspdown");
            }
            catch (UnknownTransitionException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void sendAspUp() {
        long now = System.currentTimeMillis();
        if (now - this.aspupSentTime > 2000L) {
            ASPUp aspUp = (ASPUp)this.messageFactory.createMessage(3, 1);
            aspUp.setASPIdentifier(this.aspid);
            this.write((M3UAMessage)aspUp);
            this.aspupSentTime = now;
        }
    }

    private void handleCommUp() {
        if (this.isHeartBeatEnabled()) {
            this.heartBeatTimer.start();
            this.heartBeatTimer.reset();
            this.m3UAManagementImpl.m3uaScheduler.execute(this.heartBeatTimer);
        }
        if (this.functionality == Functionality.AS || this.functionality == Functionality.SGW && this.exchangeType == ExchangeType.DE || this.functionality == Functionality.IPSP && this.exchangeType == ExchangeType.DE || this.functionality == Functionality.IPSP && this.exchangeType == ExchangeType.SE && this.ipspType == IPSPType.CLIENT) {
            this.aspupSentTime = 0L;
            this.sendAspUp();
        }
        FastList.Node n = this.aspList.head();
        FastList.Node end = this.aspList.tail();
        while ((n = n.getNext()) != end) {
            AspImpl aspImpl = (AspImpl)n.getValue();
            try {
                FSM aspPeerFSM;
                FSM aspLocalFSM = aspImpl.getLocalFSM();
                if (aspLocalFSM != null) {
                    aspLocalFSM.signal("commup");
                }
                if ((aspPeerFSM = aspImpl.getPeerFSM()) == null) continue;
                aspPeerFSM.signal("commup");
            }
            catch (UnknownTransitionException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onCommunicationLost(Association association) {
        logger.warn((Object)String.format("Communication channel lost for AspFactroy=%s Association=%s", this.name, association.getName()));
        this.handleCommDown();
    }

    public void onCommunicationRestart(Association association) {
        logger.warn((Object)String.format("Communication channel restart for AspFactroy=%s Association=%s", this.name, association.getName()));
        try {
            this.transportManagement.stopAssociation(this.associationName);
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Error while trying to stop underlying Association for AspFactpry=%s", this.getName()), (Throwable)e);
        }
        try {
            this.transportManagement.startAssociation(this.associationName);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while trying to start underlying Association for AspFactpry=%s", this.getName()), (Throwable)e);
        }
    }

    public void onCommunicationShutdown(Association association) {
        logger.warn((Object)String.format("Communication channel shutdown for AspFactroy=%s Association=%s", this.name, association.getName()));
        this.handleCommDown();
    }

    public void onCommunicationUp(Association association, int maxInboundStreams, int maxOutboundStreams) {
        this.maxOutboundStreams = maxOutboundStreams;
        this.createSLSTable(Math.min(maxInboundStreams, maxOutboundStreams) - 1);
        this.handleCommUp();
    }

    protected void createSLSTable(int minimumBoundStream) {
        if (minimumBoundStream == 0) {
            for (int i = 0; i < this.maxSequenceNumber; ++i) {
                this.slsTable[i] = 0;
            }
        } else {
            int stream = 1;
            for (int i = 0; i < this.maxSequenceNumber; ++i) {
                if (stream > minimumBoundStream) {
                    stream = 1;
                }
                this.slsTable[i] = stream++;
            }
        }
    }

    public void onPayload(Association association, PayloadData payloadData) {
        try {
            if (this.m3UAManagementImpl.sctpLibNettySupport) {
                ByteBuf byteBuf = payloadData.getByteBuf();
                this.processPayload(association.getIpChannelType(), byteBuf);
            } else {
                byte[] m3uadata = payloadData.getData();
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])m3uadata);
                this.processPayload(association.getIpChannelType(), byteBuf);
            }
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Error while trying to process PayloadData from SCTP layer. payloadData=%s", payloadData), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPayload(IpChannelType ipChannelType, ByteBuf byteBuf) {
        if (ipChannelType == IpChannelType.SCTP) {
            try {
                M3UAMessage m3UAMessage = this.messageFactory.createMessage(byteBuf);
                if (this.isHeartBeatEnabled()) {
                    this.heartBeatTimer.reset();
                }
                this.read(m3UAMessage);
            }
            finally {
                ReferenceCountUtil.release((Object)byteBuf);
            }
        } else {
            M3UAMessage m3UAMessage;
            if (this.tcpIncBuffer == null) {
                this.tcpIncBuffer = byteBuf.alloc().compositeBuffer();
            }
            this.tcpIncBuffer.addComponent(byteBuf);
            this.tcpIncBuffer.writerIndex(this.tcpIncBuffer.capacity());
            while ((m3UAMessage = this.messageFactory.createMessage((ByteBuf)this.tcpIncBuffer)) != null) {
                if (this.isHeartBeatEnabled()) {
                    this.heartBeatTimer.reset();
                }
                this.read(m3UAMessage);
            }
            this.tcpIncBuffer.discardReadBytes();
        }
    }

    public void inValidStreamId(PayloadData payloadData) {
        logger.error((Object)String.format("Tx : PayloadData with streamNumber=%d which is greater than or equal to maxSequenceNumber=%d. Droping PayloadData=%s", payloadData.getStreamNumber(), this.maxOutboundStreams, payloadData));
    }

    public void show(StringBuffer sb) {
        sb.append("ASP name=").append(this.name).append(" aspid=").append(this.aspid.getAspId()).append(" heartbeat=").append(this.isHeartBeatEnabled()).append(" sctpAssoc=").append(this.associationName).append(" started=").append(this.started);
        sb.append("\n");
        sb.append("Assigned to :\n");
        FastList.Node n = this.aspList.head();
        FastList.Node end = this.aspList.tail();
        while ((n = n.getNext()) != end) {
            AspImpl aspImpl = (AspImpl)n.getValue();
            sb.append("        ").append("AS name=").append(aspImpl.getAs().getName()).append(" functionality=").append(this.functionality).append(" mode=").append(this.exchangeType);
            if (this.functionality == Functionality.IPSP) {
                sb.append(" ipspType=").append(this.ipspType);
            }
            if (aspImpl.getLocalFSM() != null) {
                sb.append(" localFSMState=").append(aspImpl.getLocalFSM().getState());
            }
            if (aspImpl.getPeerFSM() != null) {
                sb.append(" peerFSMState=").append(aspImpl.getPeerFSM().getState());
            }
            sb.append("\n");
        }
    }

    static /* synthetic */ int[] access$102(AspFactoryImpl x0, int[] x1) {
        x0.slsTable = x1;
        return x1;
    }
}

