/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.MessageHandler;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationAvailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationRestricted;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationStateAudit;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationUPUnavailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.DestinationUnavailable;
import org.mobicents.protocols.ss7.m3ua.message.ssnm.SignallingCongestion;
import org.mobicents.protocols.ss7.m3ua.parameter.AffectedPointCode;
import org.mobicents.protocols.ss7.m3ua.parameter.CongestedIndication;
import org.mobicents.protocols.ss7.m3ua.parameter.ErrorCode;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.UserCause;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusCause;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;

public class SignalingNetworkManagementHandler
extends MessageHandler {
    private static final Logger logger = Logger.getLogger(SignalingNetworkManagementHandler.class);

    public SignalingNetworkManagementHandler(AspFactoryImpl aspFactoryImpl) {
        super(aspFactoryImpl);
    }

    public void handleDestinationUnavailable(DestinationUnavailable duna) {
        RoutingContext rcObj = duna.getRoutingContexts();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS) {
            if (rcObj == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                    this.sendError(rcObj, errorCodeObj);
                    logger.error((Object)String.format("Rx : DUNA=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sending back Error", duna, this.aspFactoryImpl.getName()));
                    return;
                }
                FSM fsm = aspImpl.getLocalFSM();
                if (fsm == null) {
                    logger.error((Object)String.format("Rx : DUNA=%s for ASP=%s. But Local FSM is null.", duna, this.aspFactoryImpl.getName()));
                    return;
                }
                AspState aspState = AspState.getState(fsm.getState().getName());
                if (aspState == AspState.ACTIVE) {
                    AffectedPointCode affectedPcObjs = duna.getAffectedPointCodes();
                    int[] affectedPcs = affectedPcObjs.getPointCodes();
                    for (int i = 0; i < affectedPcs.length; ++i) {
                        Mtp3PausePrimitive mtpPausePrimi = new Mtp3PausePrimitive(affectedPcs[i]);
                        ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendPauseMessageToLocalUser(mtpPausePrimi);
                    }
                } else {
                    logger.error((Object)String.format("Rx : DUNA for null RoutingContext. But ASP State=%s. Message=%s", new Object[]{aspState, duna}));
                }
            } else {
                long[] rcs = rcObj.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObjTemp = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObjTemp, errorCodeObj);
                        logger.error((Object)String.format("Rx : DUNA=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", duna, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    FSM fsm = aspImpl.getLocalFSM();
                    if (fsm == null) {
                        logger.error((Object)String.format("Rx : DUNA=%s for ASP=%s. But Local FSM is null.", duna, this.aspFactoryImpl.getName()));
                        return;
                    }
                    AspState aspState = AspState.getState(fsm.getState().getName());
                    if (aspState == AspState.ACTIVE) {
                        AffectedPointCode affectedPcObjs = duna.getAffectedPointCodes();
                        int[] affectedPcs = affectedPcObjs.getPointCodes();
                        for (int i = 0; i < affectedPcs.length; ++i) {
                            Mtp3PausePrimitive mtpPausePrimi = new Mtp3PausePrimitive(affectedPcs[i]);
                            ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendPauseMessageToLocalUser(mtpPausePrimi);
                        }
                        continue;
                    }
                    logger.error((Object)String.format("Rx : DUNA for RoutingContext=%d. But ASP State=%s. Message=%s", new Object[]{rcs[count], aspState, duna}));
                }
            }
        } else {
            logger.error((Object)String.format("Rx : DUNA =%s But AppServer Functionality is not As. Sending back ErrorCode.Unexpected_Message", duna));
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rcObj, errorCodeObj);
        }
    }

    public void handleDestinationAvailable(DestinationAvailable dava) {
        RoutingContext rcObj = dava.getRoutingContexts();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS) {
            if (rcObj == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                    this.sendError(rcObj, errorCodeObj);
                    logger.error((Object)String.format("Rx : DAVA=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sending back Error", dava, this.aspFactoryImpl.getName()));
                    return;
                }
                FSM fsm = aspImpl.getLocalFSM();
                if (fsm == null) {
                    logger.error((Object)String.format("Rx : DAVA=%s for ASP=%s. But Local FSM is null.", dava, this.aspFactoryImpl.getName()));
                    return;
                }
                AspState aspState = AspState.getState(fsm.getState().getName());
                if (aspState == AspState.ACTIVE) {
                    AffectedPointCode affectedPcObjs = dava.getAffectedPointCodes();
                    int[] affectedPcs = affectedPcObjs.getPointCodes();
                    for (int i = 0; i < affectedPcs.length; ++i) {
                        Mtp3ResumePrimitive mtpResumePrimi = new Mtp3ResumePrimitive(affectedPcs[i]);
                        ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendResumeMessageToLocalUser(mtpResumePrimi);
                    }
                } else {
                    logger.error((Object)String.format("Rx : DAVA for null RoutingContext. But ASP State=%s. Message=%s", new Object[]{aspState, dava}));
                }
            } else {
                long[] rcs = rcObj.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObjTemp = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObjTemp, errorCodeObj);
                        logger.error((Object)String.format("Rx : DAVA=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", dava, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    FSM fsm = aspImpl.getLocalFSM();
                    if (fsm == null) {
                        logger.error((Object)String.format("Rx : DAVA=%s for ASP=%s. But Local FSM is null", dava, this.aspFactoryImpl.getName()));
                        return;
                    }
                    AspState aspState = AspState.getState(fsm.getState().getName());
                    if (aspState == AspState.ACTIVE) {
                        AffectedPointCode affectedPcObjs = dava.getAffectedPointCodes();
                        int[] affectedPcs = affectedPcObjs.getPointCodes();
                        for (int i = 0; i < affectedPcs.length; ++i) {
                            Mtp3ResumePrimitive mtpResumePrimi = new Mtp3ResumePrimitive(affectedPcs[i]);
                            ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendResumeMessageToLocalUser(mtpResumePrimi);
                        }
                        continue;
                    }
                    logger.error((Object)String.format("Rx : DAVA for RoutingContext=%d. But ASP State=%s. Message=%s", new Object[]{rcs[count], aspState, dava}));
                }
            }
        } else {
            logger.error((Object)String.format("Rx : DAVA =%s But AppServer Functionality is not As. Sending back ErrorCode.Unexpected_Message", dava));
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rcObj, errorCodeObj);
        }
    }

    public void handleDestinationStateAudit(DestinationStateAudit daud) {
        RoutingContext rcObj = daud.getRoutingContexts();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.SGW) {
            logger.warn((Object)String.format("Received DAUD=%s. Handling of DAUD message is not yet implemented", daud));
        } else {
            logger.error((Object)String.format("Rx : DAUD =%s But AppServer Functionality is not SGW. Sending back ErrorCode.Unexpected_Message", daud));
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rcObj, errorCodeObj);
        }
    }

    public void handleSignallingCongestion(SignallingCongestion scon) {
        RoutingContext rcObj = scon.getRoutingContexts();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP) {
            if (rcObj == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                    this.sendError(rcObj, errorCodeObj);
                    logger.error((Object)String.format("Rx : SCON=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sending back Error", scon, this.aspFactoryImpl.getName()));
                    return;
                }
                FSM fsm = aspImpl.getLocalFSM();
                if (fsm == null) {
                    logger.error((Object)String.format("Rx : SCON=%s for ASP=%s. But Local FSM is null.", scon, this.aspFactoryImpl.getName()));
                    return;
                }
                AspState aspState = AspState.getState(fsm.getState().getName());
                if (aspState == AspState.ACTIVE) {
                    AffectedPointCode affectedPcObjs = scon.getAffectedPointCodes();
                    int[] affectedPcs = affectedPcObjs.getPointCodes();
                    int cong = 0;
                    for (int i = 0; i < affectedPcs.length; ++i) {
                        CongestedIndication.CongestionLevel congLevel;
                        CongestedIndication congeInd = scon.getCongestedIndication();
                        if (congeInd != null && (congLevel = congeInd.getCongestionLevel()) != null) {
                            cong = congLevel.getLevel();
                        }
                        Mtp3StatusPrimitive mtpPausePrimi = new Mtp3StatusPrimitive(affectedPcs[i], Mtp3StatusCause.SignallingNetworkCongested, cong, 0);
                        ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendStatusMessageToLocalUser(mtpPausePrimi);
                    }
                } else {
                    logger.error((Object)String.format("Rx : SCON for null RoutingContext. But ASP State=%s. Message=%s", new Object[]{aspState, scon}));
                }
            } else {
                long[] rcs = rcObj.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObjTemp = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObjTemp, errorCodeObj);
                        logger.error((Object)String.format("Rx : SCON=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", scon, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    FSM fsm = aspImpl.getLocalFSM();
                    if (fsm == null) {
                        logger.error((Object)String.format("Rx : SCON=%s for ASP=%s. But Local FSM is null", scon, this.aspFactoryImpl.getName()));
                        return;
                    }
                    AspState aspState = AspState.getState(fsm.getState().getName());
                    if (aspState == AspState.ACTIVE) {
                        AffectedPointCode affectedPcObjs = scon.getAffectedPointCodes();
                        int[] affectedPcs = affectedPcObjs.getPointCodes();
                        int cong = 0;
                        for (int i = 0; i < affectedPcs.length; ++i) {
                            CongestedIndication.CongestionLevel congLevel;
                            CongestedIndication congeInd = scon.getCongestedIndication();
                            if (congeInd != null && (congLevel = congeInd.getCongestionLevel()) != null) {
                                cong = congLevel.getLevel();
                            }
                            Mtp3StatusPrimitive mtpPausePrimi = new Mtp3StatusPrimitive(affectedPcs[i], Mtp3StatusCause.SignallingNetworkCongested, cong, 0);
                            ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendStatusMessageToLocalUser(mtpPausePrimi);
                        }
                        continue;
                    }
                    logger.error((Object)String.format("Rx : DAVA for RoutingContext=%d. But ASP State=%s. Message=%s", new Object[]{rcs[count], aspState, scon}));
                }
            }
        } else {
            logger.error((Object)String.format("Rx : SCON =%s But AppServer Functionality is not AS or IPSP. Sending back ErrorCode.Unexpected_Message", scon));
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rcObj, errorCodeObj);
        }
    }

    public void handleDestinationUPUnavailable(DestinationUPUnavailable dupu) {
        RoutingContext rcObj = dupu.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS) {
            if (rcObj == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                    this.sendError(rcObj, errorCodeObj);
                    logger.error((Object)String.format("Rx : DUPU=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sending back Error", dupu, this.aspFactoryImpl.getName()));
                    return;
                }
                FSM fsm = aspImpl.getLocalFSM();
                if (fsm == null) {
                    logger.error((Object)String.format("Rx : DUPU=%s for ASP=%s. But Local FSM is null.", dupu, this.aspFactoryImpl.getName()));
                    return;
                }
                AspState aspState = AspState.getState(fsm.getState().getName());
                if (aspState == AspState.ACTIVE) {
                    AffectedPointCode affectedPcObjs = dupu.getAffectedPointCode();
                    int[] affectedPcs = affectedPcObjs.getPointCodes();
                    int cause = 0;
                    for (int i = 0; i < affectedPcs.length; ++i) {
                        UserCause userCause = dupu.getUserCause();
                        cause = userCause.getCause();
                        Mtp3StatusPrimitive mtpPausePrimi = new Mtp3StatusPrimitive(affectedPcs[i], Mtp3StatusCause.getMtp3StatusCause((int)cause), 0, 0);
                        ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendStatusMessageToLocalUser(mtpPausePrimi);
                    }
                } else {
                    logger.error((Object)String.format("Rx : DUPU for null RoutingContext. But ASP State=%s. Message=%s", new Object[]{aspState, dupu}));
                }
            } else {
                long[] rcs = rcObj.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObjTemp = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObjTemp, errorCodeObj);
                        logger.error((Object)String.format("Rx : DUPU=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", dupu, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    FSM fsm = aspImpl.getLocalFSM();
                    if (fsm == null) {
                        logger.error((Object)String.format("Rx : DUPU=%s for ASP=%s. But Local FSM is null", dupu, this.aspFactoryImpl.getName()));
                        return;
                    }
                    AspState aspState = AspState.getState(fsm.getState().getName());
                    if (aspState == AspState.ACTIVE) {
                        AffectedPointCode affectedPcObjs = dupu.getAffectedPointCode();
                        int[] affectedPcs = affectedPcObjs.getPointCodes();
                        int cause = 0;
                        for (int i = 0; i < affectedPcs.length; ++i) {
                            UserCause userCause = dupu.getUserCause();
                            cause = userCause.getCause();
                            Mtp3StatusPrimitive mtpPausePrimi = new Mtp3StatusPrimitive(affectedPcs[i], Mtp3StatusCause.getMtp3StatusCause((int)cause), 0, 0);
                            ((AsImpl)aspImpl.getAs()).getM3UAManagement().sendStatusMessageToLocalUser(mtpPausePrimi);
                        }
                        continue;
                    }
                    logger.error((Object)String.format("Rx : DUPU for RoutingContext=%d. But ASP State=%s. Message=%s", new Object[]{rcs[count], aspState, dupu}));
                }
            }
        } else {
            logger.error((Object)String.format("Rx : DUPU =%s But AppServer Functionality is not AS. Sending back ErrorCode.Unexpected_Message", dupu));
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rcObj, errorCodeObj);
        }
    }

    public void handleDestinationRestricted(DestinationRestricted drst) {
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS && logger.isEnabledFor((Priority)Level.WARN)) {
            logger.warn((Object)String.format("Received DRST message for AS side. Not implemented yet", drst));
        }
    }
}

