/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.mobicents.protocols.ss7.m3ua.message.M3UAMessage;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsActToActRemAspUp
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsActToActRemAspUp.class);
    private AsImpl asImpl = null;
    private FSM fsm;

    public THLocalAsActToActRemAspUp(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            AspImpl remAsp = (AspImpl)this.fsm.getAttribute("asp");
            if (remAsp == null) {
                logger.error((Object)String.format("No ASP found. %s", this.fsm.toString()));
                return false;
            }
            Notify msg = this.createNotify(remAsp);
            remAsp.getAspFactory().write((M3UAMessage)msg);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while translating Rem AS to INACTIVE message. %s", this.fsm.toString()), (Throwable)e);
            return false;
        }
    }

    private Notify createNotify(AspImpl remAsp) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(1, 3);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

