/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.message;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.message.M3UAMessage;
import org.mobicents.protocols.ss7.m3ua.parameter.Parameter;

public abstract class M3UAMessageImpl
implements M3UAMessage {
    private int messageClass;
    private int messageType;
    private String message;
    protected FastMap<Short, Parameter> parameters = new FastMap();
    private ParameterFactoryImpl factory = new ParameterFactoryImpl();
    int initialPosition = 0;

    public M3UAMessageImpl(String message) {
        this.message = message;
    }

    protected M3UAMessageImpl(int messageClass, int messageType, String message) {
        this(message);
        this.messageClass = messageClass;
        this.messageType = messageType;
    }

    protected abstract void encodeParams(ByteBuffer var1);

    public void encode(ByteBuf byteBuf) {
        byteBuf.writeByte(1);
        byteBuf.writeByte(0);
        byteBuf.writeByte(this.messageClass);
        byteBuf.writeByte(this.messageType);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        this.encodeParams(buffer);
        int length = buffer.position();
        byte[] data = new byte[length];
        buffer.flip();
        buffer.get(data);
        byteBuf.writeInt(length + 8);
        byteBuf.writeBytes(data);
    }

    protected void decode(ByteBuf data) {
        while (data.readableBytes() >= 4) {
            short tag = (short)(data.readUnsignedByte() << 8 | data.readUnsignedByte());
            short len = (short)(data.readUnsignedByte() << 8 | data.readUnsignedByte());
            if (data.readableBytes() < len - 4) {
                return;
            }
            byte[] value = new byte[len - 4];
            data.readBytes(value);
            this.parameters.put((Object)tag, (Object)this.factory.createParameter(tag, value));
            int padding = 4 - len % 4;
            if (padding >= 4) continue;
            if (data.readableBytes() < padding) {
                return;
            }
            data.skipBytes(padding);
        }
    }

    public int getMessageClass() {
        return this.messageClass;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public String toString() {
        TextBuilder tb = new TextBuilder();
        tb.append(this.message).append(" Params(");
        FastMap.Entry e = this.parameters.head();
        FastMap.Entry end = this.parameters.tail();
        while ((e = e.getNext()) != end) {
            Parameter value = (Parameter)e.getValue();
            tb.append(value.toString());
            tb.append(", ");
        }
        tb.append(")");
        return tb.toString();
    }
}

