/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.message;

import io.netty.buffer.ByteBuf;
import org.mobicents.protocols.ss7.m3ua.impl.message.M3UAMessageImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPDownAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPDownImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPUpAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPUpImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.HeartbeatAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.HeartbeatImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPActiveAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPActiveImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPInactiveAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPInactiveImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.mgmt.ErrorImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.mgmt.NotifyImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.DeregistrationRequestImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.DeregistrationResponseImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.RegistrationRequestImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.RegistrationResponseImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationAvailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationRestrictedImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationStateAuditImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationUPUnavailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationUnavailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.SignallingCongestionImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.transfer.PayloadDataImpl;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;

public class MessageFactoryImpl
implements MessageFactory {
    public M3UAMessageImpl createMessage(int messageClass, int messageType) {
        switch (messageClass) {
            case 1: {
                switch (messageType) {
                    case 1: {
                        return new PayloadDataImpl();
                    }
                }
                break;
            }
            case 2: {
                switch (messageType) {
                    case 1: {
                        return new DestinationUnavailableImpl();
                    }
                    case 2: {
                        return new DestinationAvailableImpl();
                    }
                    case 3: {
                        return new DestinationStateAuditImpl();
                    }
                    case 4: {
                        return new SignallingCongestionImpl();
                    }
                    case 5: {
                        return new DestinationUPUnavailableImpl();
                    }
                    case 6: {
                        return new DestinationRestrictedImpl();
                    }
                }
                break;
            }
            case 3: {
                switch (messageType) {
                    case 1: {
                        return new ASPUpImpl();
                    }
                    case 4: {
                        return new ASPUpAckImpl();
                    }
                    case 2: {
                        return new ASPDownImpl();
                    }
                    case 5: {
                        return new ASPDownAckImpl();
                    }
                    case 3: {
                        return new HeartbeatImpl();
                    }
                    case 6: {
                        return new HeartbeatAckImpl();
                    }
                }
                break;
            }
            case 4: {
                switch (messageType) {
                    case 1: {
                        return new ASPActiveImpl();
                    }
                    case 3: {
                        return new ASPActiveAckImpl();
                    }
                    case 2: {
                        return new ASPInactiveImpl();
                    }
                    case 4: {
                        return new ASPInactiveAckImpl();
                    }
                }
                break;
            }
            case 9: {
                switch (messageType) {
                    case 1: {
                        return new RegistrationRequestImpl();
                    }
                    case 2: {
                        return new RegistrationResponseImpl();
                    }
                    case 3: {
                        return new DeregistrationRequestImpl();
                    }
                    case 4: {
                        return new DeregistrationResponseImpl();
                    }
                }
            }
            case 0: {
                switch (messageType) {
                    case 0: {
                        return new ErrorImpl();
                    }
                    case 1: {
                        return new NotifyImpl();
                    }
                }
            }
        }
        return null;
    }

    public M3UAMessageImpl createMessage(ByteBuf message) {
        if (message.readableBytes() < 8) {
            return null;
        }
        message.markReaderIndex();
        message.skipBytes(2);
        short messageClass = message.readUnsignedByte();
        short messageType = message.readUnsignedByte();
        int dataLen = message.readInt() - 8;
        if (message.readableBytes() < dataLen) {
            message.resetReaderIndex();
            return null;
        }
        M3UAMessageImpl messageTemp = this.createMessage(messageClass, messageType);
        message.markWriterIndex();
        message.writerIndex(message.readerIndex() + dataLen);
        messageTemp.decode(message);
        message.resetWriterIndex();
        return messageTemp;
    }
}

