/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.router;

import javolution.util.FastList;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.router.SINode;

public class OPCNode {
    protected int dpc;
    protected int opc;
    protected FastList<SINode> siList = new FastList();
    private SINode wildCardSINode;

    protected OPCNode(int dpc, int opc) {
        this.dpc = dpc;
        this.opc = opc;
    }

    protected void addSi(int si, AsImpl asImpl) throws Exception {
        FastList.Node n = this.siList.head();
        FastList.Node end = this.siList.tail();
        while ((n = n.getNext()) != end) {
            SINode siNode = (SINode)n.getValue();
            if (siNode.si != si) continue;
            throw new Exception(String.format("Service indicator %d already exist for OPC %d and DPC %d", si, this.opc, this.dpc));
        }
        SINode siNode = new SINode(si, asImpl);
        this.siList.add((Object)siNode);
        if (si == -1) {
            this.wildCardSINode = siNode;
        }
    }

    protected AsImpl getAs(short si) {
        FastList.Node n = this.siList.head();
        FastList.Node end = this.siList.tail();
        while ((n = n.getNext()) != end) {
            SINode siNode = (SINode)n.getValue();
            if (siNode.si != si) continue;
            return siNode.asImpl;
        }
        if (this.wildCardSINode != null) {
            return this.wildCardSINode.asImpl;
        }
        return null;
    }
}

