/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx;

import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cxdx.CxDxMessageFactory;
import net.java.slee.resource.diameter.cxdx.events.LocationInfoRequest;
import net.java.slee.resource.diameter.cxdx.events.MultimediaAuthenticationRequest;
import net.java.slee.resource.diameter.cxdx.events.PushProfileRequest;
import net.java.slee.resource.diameter.cxdx.events.RegistrationTerminationRequest;
import net.java.slee.resource.diameter.cxdx.events.ServerAssignmentRequest;
import net.java.slee.resource.diameter.cxdx.events.UserAuthorizationRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.LocationInfoAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.LocationInfoRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.MultimediaAuthenticationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.MultimediaAuthenticationRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.PushProfileAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.PushProfileRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.RegistrationTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.RegistrationTerminationRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.ServerAssignmentAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.ServerAssignmentRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.UserAuthorizationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.UserAuthorizationRequestImpl;

public class CxDxMessageFactoryImpl
extends DiameterMessageFactoryImpl
implements CxDxMessageFactory {
    private static Logger logger = Logger.getLogger(CxDxMessageFactoryImpl.class);
    private DiameterAvpFactory baseAvpFactory = null;
    protected DiameterMessageFactory baseFactory = null;
    private ApplicationId cxdxAppId = ApplicationId.createByAuthAppId((long)10415L, (long)0x1000000L);
    private DiameterAvp[] EMPTY_AVP_ARRAY = new DiameterAvp[0];

    public CxDxMessageFactoryImpl(DiameterMessageFactory baseFactory, Session session, Stack stack, DiameterIdentity ... avps) {
        super(session, stack, avps);
        this.baseAvpFactory = new DiameterAvpFactoryImpl();
        this.baseFactory = baseFactory;
    }

    public CxDxMessageFactoryImpl(DiameterMessageFactory baseFactory, Stack stack) {
        super(stack);
        this.baseAvpFactory = new DiameterAvpFactoryImpl();
        this.baseFactory = baseFactory;
    }

    public void setApplicationId(long vendorId, long applicationId) {
        this.cxdxAppId = ApplicationId.createByAuthAppId((long)vendorId, (long)applicationId);
    }

    public ApplicationId getApplicationId() {
        return this.cxdxAppId;
    }

    public LocationInfoRequest createLocationInfoRequest() {
        try {
            return (LocationInfoRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 302, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Location-Info-Request", (Throwable)e);
            return null;
        }
    }

    public LocationInfoRequest createLocationInfoRequest(String sessionId) throws IllegalArgumentException {
        LocationInfoRequest lir = this.createLocationInfoRequest();
        lir.setSessionId(sessionId);
        return lir;
    }

    public MultimediaAuthenticationRequest createMultimediaAuthenticationRequest() {
        try {
            return (MultimediaAuthenticationRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 303, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Multimedia-Authentication-Request", (Throwable)e);
            return null;
        }
    }

    public MultimediaAuthenticationRequest createMultimediaAuthenticationRequest(String sessionId) throws IllegalArgumentException {
        MultimediaAuthenticationRequest mar = this.createMultimediaAuthenticationRequest();
        mar.setSessionId(sessionId);
        return mar;
    }

    public PushProfileRequest createPushProfileRequest() {
        try {
            return (PushProfileRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 305, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Push-Profile-Request", (Throwable)e);
            return null;
        }
    }

    public PushProfileRequest createPushProfileRequest(String sessionId) throws IllegalArgumentException {
        PushProfileRequest ppr = this.createPushProfileRequest();
        ppr.setSessionId(sessionId);
        return ppr;
    }

    public RegistrationTerminationRequest createRegistrationTerminationRequest() {
        try {
            return (RegistrationTerminationRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 304, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Registration-Termination-Request", (Throwable)e);
            return null;
        }
    }

    public RegistrationTerminationRequest createRegistrationTerminationRequest(String sessionId) throws IllegalArgumentException {
        RegistrationTerminationRequest rtr = this.createRegistrationTerminationRequest();
        rtr.setSessionId(sessionId);
        return rtr;
    }

    public ServerAssignmentRequest createServerAssignmentRequest() {
        try {
            return (ServerAssignmentRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 301, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Server-Assignment-Request", (Throwable)e);
            return null;
        }
    }

    public ServerAssignmentRequest createServerAssignmentRequest(String sessionId) throws IllegalArgumentException {
        ServerAssignmentRequest sar = this.createServerAssignmentRequest();
        sar.setSessionId(sessionId);
        return sar;
    }

    public UserAuthorizationRequest createUserAuthorizationRequest() {
        try {
            return (UserAuthorizationRequest)this.createCxDxMessage(null, this.EMPTY_AVP_ARRAY, 300, this.cxdxAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create User-Authorization-Request", (Throwable)e);
            return null;
        }
    }

    public UserAuthorizationRequest createUserAuthorizationRequest(String sessionId) throws IllegalArgumentException {
        UserAuthorizationRequest uar = this.createUserAuthorizationRequest();
        uar.setSessionId(sessionId);
        return uar;
    }

    public DiameterMessageFactory getBaseMessageFactory() {
        return this.baseFactory;
    }

    DiameterMessage createCxDxMessage(DiameterHeader diameterHeader, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws InternalException {
        Message raw;
        boolean creatingRequest = diameterHeader == null;
        Message msg = null;
        if (!creatingRequest) {
            raw = this.createMessage(diameterHeader, avps, 0, appId);
            raw.setProxiable(diameterHeader.isProxiable());
            raw.setRequest(false);
            raw.setReTransmitted(false);
            msg = raw;
        } else {
            raw = this.createMessage(diameterHeader, avps, _commandCode, appId);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = raw;
        }
        int commandCode = creatingRequest ? _commandCode : diameterHeader.getCommandCode();
        ExtensionDiameterMessageImpl diamMessage = null;
        switch (commandCode) {
            case 302: {
                diamMessage = creatingRequest ? new LocationInfoRequestImpl(msg) : new LocationInfoAnswerImpl(msg);
                break;
            }
            case 303: {
                diamMessage = creatingRequest ? new MultimediaAuthenticationRequestImpl(msg) : new MultimediaAuthenticationAnswerImpl(msg);
                break;
            }
            case 305: {
                diamMessage = creatingRequest ? new PushProfileRequestImpl(msg) : new PushProfileAnswerImpl(msg);
                break;
            }
            case 304: {
                diamMessage = creatingRequest ? new RegistrationTerminationRequestImpl(msg) : new RegistrationTerminationAnswerImpl(msg);
                break;
            }
            case 301: {
                diamMessage = creatingRequest ? new ServerAssignmentRequestImpl(msg) : new ServerAssignmentAnswerImpl(msg);
                break;
            }
            case 300: {
                diamMessage = creatingRequest ? new UserAuthorizationRequestImpl(msg) : new UserAuthorizationAnswerImpl(msg);
                break;
            }
            default: {
                diamMessage = new ExtensionDiameterMessageImpl(msg);
            }
        }
        if (!diamMessage.hasSessionId() && this.session != null) {
            diamMessage.setSessionId(this.session.getSessionId());
        }
        return diamMessage;
    }
}

