/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cxdx.CxDxAVPFactory;
import net.java.slee.resource.diameter.cxdx.CxDxClientSessionActivity;
import net.java.slee.resource.diameter.cxdx.CxDxMessageFactory;
import net.java.slee.resource.diameter.cxdx.CxDxProvider;
import net.java.slee.resource.diameter.cxdx.CxDxServerSessionActivity;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.cxdx.ClientCxDxSession;
import org.jdiameter.api.cxdx.ServerCxDxSession;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.AccountingSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.AuthorizationSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.cxdx.CxDxAVPFactoryImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxClientSessionImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.cxdx.CxDxServerSessionImpl;
import org.mobicents.slee.resource.diameter.cxdx.EventIDCache;
import org.mobicents.slee.resource.diameter.cxdx.events.LocationInfoAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.LocationInfoRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.MultimediaAuthenticationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.MultimediaAuthenticationRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.PushProfileAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.PushProfileRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.RegistrationTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.RegistrationTerminationRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.ServerAssignmentAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.ServerAssignmentRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.UserAuthorizationAnswerImpl;
import org.mobicents.slee.resource.diameter.cxdx.events.UserAuthorizationRequestImpl;
import org.mobicents.slee.resource.diameter.cxdx.handlers.CxDxSessionFactory;

public class DiameterCxDxResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private List<ApplicationId> authApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private DiameterBaseMarshaler marshaler;
    private Stack stack;
    private long messageTimeout = 5000L;
    private long activityRemoveDelay = 30000L;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private DiameterAvpFactory baseAvpFactory = null;
    private DiameterMessageFactoryImpl baseMessageFactory;
    private SessionFactory sessionFactory = null;
    private CxDxAVPFactory cxdxAvpFactory;
    private CxDxMessageFactory cxdxMessageFactory;
    private CxDxSessionFactory cxdxSessionFactory = null;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities = null;
    private transient CxDxProviderImpl raProvider = null;
    protected transient AuthorizationSessionFactory authSessionFactory = null;
    protected transient AccountingSessionFactory accSessionFactory = null;
    protected transient SessionFactory proxySessionFactory = null;
    private static final int EVENT_FLAGS = DiameterCxDxResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterCxDxResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new CxDxProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter Cx/Dx RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = null;
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(this.diameterMultiplexerObjectName)) {
                object = ManagementFactory.getPlatformMBeanServer().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via Platform MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            } else {
                object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via JBoss MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            }
            if (object != null && object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.baseMessageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.cxdxAvpFactory = new CxDxAVPFactoryImpl(this.baseAvpFactory);
            this.cxdxMessageFactory = new CxDxMessageFactoryImpl((DiameterMessageFactory)this.baseMessageFactory, this.stack);
            ApplicationId firstAppId = this.authApplicationIds.get(0);
            ((CxDxMessageFactoryImpl)this.cxdxMessageFactory).setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            this.sessionFactory = this.stack.getSessionFactory();
            this.cxdxSessionFactory = new CxDxSessionFactory(this, this.messageTimeout, this.sessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerCxDxSession.class, (IAppSessionFactory)this.cxdxSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientCxDxSession.class, (IAppSessionFactory)this.cxdxSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter Cx/Dx RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister Cx/Dx RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: raStopping completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: raInactive completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                appIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
            this.authApplicationIds = appIds;
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: queryLiveness :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: getActivity :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return null;
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAfterEventDelivery(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        DiameterActivityImpl activity = (DiameterActivityImpl)this.getActivity(handle);
        if (activity != null) {
            DiameterActivityImpl diameterActivityImpl = activity;
            synchronized (diameterActivityImpl) {
                if (activity.isTerminateAfterProcessing()) {
                    activity.endActivity();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter Cx/Dx RA :: activityEnded :: handle[" + handle + ".");
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.startActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to start activity remove timer.", (Throwable)e);
        }
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.stopActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to stop activity remove timer.", (Throwable)e);
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.activityEnded(handle);
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle handle) {
        this.sleeEndpoint.endActivity((ActivityHandle)handle);
    }

    public void update(DiameterActivityHandle handle, DiameterActivity activity) {
        this.activities.update(handle, activity);
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 300: {
                return isRequest ? new UserAuthorizationRequestImpl(message) : new UserAuthorizationAnswerImpl(message);
            }
            case 301: {
                return isRequest ? new ServerAssignmentRequestImpl(message) : new ServerAssignmentAnswerImpl(message);
            }
            case 302: {
                return isRequest ? new LocationInfoRequestImpl(message) : new LocationInfoAnswerImpl(message);
            }
            case 303: {
                return isRequest ? new MultimediaAuthenticationRequestImpl(message) : new MultimediaAuthenticationAnswerImpl(message);
            }
            case 304: {
                return isRequest ? new RegistrationTerminationRequestImpl(message) : new RegistrationTerminationAnswerImpl(message);
            }
            case 305: {
                return isRequest ? new PushProfileRequestImpl(message) : new PushProfileAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, DEFAULT_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, DEFAULT_ACTIVITY_FLAGS);
            }
            activity.setSessionListener((Object)this);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        try {
            this.raProvider.createActivity((Message)request);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Cx/Dx RA :: receivedSuccessMessage :: Request[" + request + "], Answer[" + answer + "].");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + answer.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Cx/Dx RA :: timeoutExpired :: Request[" + request + "].");
        }
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(request.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ServerCxDxSession session) {
        DiameterMessageFactoryImpl baseMsgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        CxDxMessageFactoryImpl sessionMsgFactory = new CxDxMessageFactoryImpl((DiameterMessageFactory)baseMsgFactory, (Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        ApplicationId firstAppId = this.authApplicationIds.get(0);
        sessionMsgFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
        CxDxServerSessionImpl serverActivity = new CxDxServerSessionImpl(sessionMsgFactory, this.cxdxAvpFactory, session, (EventListener<Request, Answer>)this, null, null, this.stack);
        serverActivity.setSessionListener(this);
    }

    public void sessionCreated(ClientCxDxSession session) {
        DiameterMessageFactoryImpl baseMsgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        CxDxMessageFactoryImpl sessionMsgFactory = new CxDxMessageFactoryImpl((DiameterMessageFactory)baseMsgFactory, (Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        ApplicationId firstAppId = this.authApplicationIds.get(0);
        sessionMsgFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
        CxDxClientSessionImpl clientActivity = new CxDxClientSessionImpl(sessionMsgFactory, this.cxdxAvpFactory, session, (EventListener<Request, Answer>)this, null, null, this.sleeEndpoint);
        clientActivity.setSessionListener(this);
    }

    public void sessionCreated(Session session) {
        DiameterMessageFactoryImpl sessionMsgFactory = new DiameterMessageFactoryImpl(session, this.stack, new DiameterIdentity[]{null, null});
        DiameterActivityImpl activity = new DiameterActivityImpl((DiameterMessageFactory)sessionMsgFactory, this.baseAvpFactory, session, (EventListener)this, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public ApplicationId[] getSupportedApplications() {
        return (ApplicationId[])this.authApplicationIds.toArray();
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        DiameterActivityHandle dah = this.getActivityHandle(source.getSessionId());
        Object activity = this.getActivity((ActivityHandle)dah);
        if (activity != null) {
            if (source instanceof ServerShSession) {
                try {
                    StateChangeListener scl = (StateChangeListener)activity;
                    scl.stateChanged((Object)source, oldState, newState);
                }
                catch (Exception e) {
                    this.tracer.warning("Failed to deliver state, for: " + dah + " on stateChanged( " + source + ", " + oldState + ", " + newState + " )", (Throwable)e);
                }
            }
        } else {
            this.tracer.warning("No activity for: " + dah + " on stateChanged( " + source + ", " + oldState + ", " + newState + " )");
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return new DiameterIdentity[0];
    }

    private class CxDxProviderImpl
    implements CxDxProvider {
        protected DiameterCxDxResourceAdaptor ra;
        protected Validator validator = new ValidatorImpl();

        public CxDxProviderImpl(DiameterCxDxResourceAdaptor cxdxResourceAdaptor) {
            this.ra = cxdxResourceAdaptor;
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterCxDxResourceAdaptor.this.activities.get(DiameterCxDxResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.isRequest()) {
                    if (message.getCommandCode() == 305 || message.getCommandCode() == 304) {
                        return this.createCxDxClientSessionActivity((Request)message, false);
                    }
                    return this.createCxDxServerSessionActivity((Request)message);
                }
                throw new IllegalStateException("Got answer, there should already be activity.");
            }
            return activity;
        }

        private DiameterActivity createCxDxServerSessionActivity(Request request) throws CreateActivityException {
            ServerCxDxSession session = null;
            try {
                String sessionId = request == null ? null : request.getSessionId();
                session = (ServerCxDxSession)((ISessionFactory)DiameterCxDxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(sessionId, ApplicationId.createByAuthAppId((long)10415L, (long)0x1000000L), ServerCxDxSession.class, new Object[]{request});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating Server Accounting Activity");
                }
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Server Accounting Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Server Accounting Activity", (Throwable)e);
            }
            CxDxServerSessionImpl activity = new CxDxServerSessionImpl(this.ra.cxdxMessageFactory, this.ra.cxdxAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), null, null, DiameterCxDxResourceAdaptor.this.stack);
            DiameterCxDxResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
            if (request != null) {
                if (request.getCommandCode() == 302) {
                    activity.fetchSessionData((DiameterMessage)new LocationInfoRequestImpl((Message)request));
                } else if (request.getCommandCode() == 303) {
                    activity.fetchSessionData((DiameterMessage)new MultimediaAuthenticationRequestImpl((Message)request));
                } else if (request.getCommandCode() == 301) {
                    activity.fetchSessionData((DiameterMessage)new ServerAssignmentRequestImpl((Message)request));
                } else if (request.getCommandCode() == 300) {
                    activity.fetchSessionData((DiameterMessage)new UserAuthorizationRequestImpl((Message)request));
                }
                ((org.jdiameter.server.impl.app.cxdx.CxDxServerSessionImpl)session).processRequest(request);
            }
            return activity;
        }

        public CxDxClientSessionActivity createCxDxClientSessionActivity() throws CreateActivityException {
            return this.createCxDxClientSessionActivity(null, false);
        }

        public CxDxServerSessionActivity createCxDxServerSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ServerCxDxSession session = (ServerCxDxSession)((ISessionFactory)DiameterCxDxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, ApplicationId.createByAuthAppId((long)10415L, (long)0x1000000L), ServerCxDxSession.class);
                CxDxServerSessionImpl activity = new CxDxServerSessionImpl(this.ra.cxdxMessageFactory, this.ra.cxdxAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), destinationHost, destinationRealm, DiameterCxDxResourceAdaptor.this.stack);
                DiameterCxDxResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
                return activity;
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        public CxDxClientSessionActivity createCxDxClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ClientCxDxSession session = (ClientCxDxSession)((ISessionFactory)DiameterCxDxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, ApplicationId.createByAuthAppId((long)10415L, (long)0x1000000L), ClientCxDxSession.class);
                CxDxMessageFactoryImpl sessionMsgFactory = new CxDxMessageFactoryImpl((DiameterMessageFactory)this.ra.baseMessageFactory, (Session)session.getSessions().get(0), DiameterCxDxResourceAdaptor.this.stack, new DiameterIdentity[0]);
                ApplicationId firstAppId = (ApplicationId)DiameterCxDxResourceAdaptor.this.authApplicationIds.get(0);
                sessionMsgFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                CxDxClientSessionImpl activity = new CxDxClientSessionImpl(sessionMsgFactory, this.ra.cxdxAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), destinationHost, destinationRealm, this.ra.sleeEndpoint);
                DiameterCxDxResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
                return activity;
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        private CxDxClientSessionActivity createCxDxClientSessionActivity(Request request, boolean suspend) throws CreateActivityException {
            try {
                String sessionId = request == null ? null : request.getSessionId();
                ClientCxDxSession session = (ClientCxDxSession)((ISessionFactory)DiameterCxDxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(sessionId, ApplicationId.createByAuthAppId((long)10415L, (long)0x1000000L), ClientCxDxSession.class);
                CxDxMessageFactoryImpl sessionMsgFactory = new CxDxMessageFactoryImpl((DiameterMessageFactory)this.ra.baseMessageFactory, (Session)session.getSessions().get(0), DiameterCxDxResourceAdaptor.this.stack, new DiameterIdentity[0]);
                ApplicationId firstAppId = (ApplicationId)DiameterCxDxResourceAdaptor.this.authApplicationIds.get(0);
                sessionMsgFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                CxDxClientSessionImpl activity = new CxDxClientSessionImpl(sessionMsgFactory, this.ra.cxdxAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), null, null, this.ra.sleeEndpoint);
                DiameterCxDxResourceAdaptor.this.addActivity((DiameterActivity)activity, suspend);
                if (request != null) {
                    if (request.getCommandCode() == 305) {
                        activity.fetchSessionData((DiameterMessage)new PushProfileRequestImpl((Message)request));
                    } else if (request.getCommandCode() == 304) {
                        activity.fetchSessionData((DiameterMessage)new RegistrationTerminationRequestImpl((Message)request));
                    }
                    ((org.jdiameter.client.impl.app.cxdx.CxDxClientSessionImpl)session).processRequest(request);
                }
                return activity;
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        public CxDxMessageFactory getCxDxMessageFactory() {
            return this.ra.cxdxMessageFactory;
        }

        public CxDxAVPFactory getCxDxAVPFactory() {
            return this.ra.cxdxAvpFactory;
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }

        public CxDxServerSessionActivity createCxDxServerSessionActivity() throws CreateActivityException {
            return this.createCxDxServerSessionActivity(null, null);
        }

        public Validator getValidator() {
            return this.validator;
        }
    }
}

