/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.cxdx.handlers;

import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.cxdx.ClientCxDxSession;
import org.jdiameter.api.cxdx.ServerCxDxSession;
import org.jdiameter.api.cxdx.events.JLocationInfoAnswer;
import org.jdiameter.api.cxdx.events.JLocationInfoRequest;
import org.jdiameter.api.cxdx.events.JMultimediaAuthAnswer;
import org.jdiameter.api.cxdx.events.JMultimediaAuthRequest;
import org.jdiameter.api.cxdx.events.JPushProfileAnswer;
import org.jdiameter.api.cxdx.events.JPushProfileRequest;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationAnswer;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationRequest;
import org.jdiameter.api.cxdx.events.JServerAssignmentAnswer;
import org.jdiameter.api.cxdx.events.JServerAssignmentRequest;
import org.jdiameter.api.cxdx.events.JUserAuthorizationAnswer;
import org.jdiameter.api.cxdx.events.JUserAuthorizationRequest;
import org.jdiameter.client.impl.app.cxdx.CxDxClientSessionImpl;
import org.jdiameter.common.impl.app.cxdx.CxDxSessionFactoryImpl;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationRequestImpl;
import org.jdiameter.server.impl.app.cxdx.CxDxServerSessionImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

public class CxDxSessionFactory
extends CxDxSessionFactoryImpl {
    private DiameterRAInterface cxdxResourceAdaptor;
    private static final Logger logger = Logger.getLogger(CxDxSessionFactory.class);

    public CxDxSessionFactory(DiameterRAInterface cxDxResourceAdaptor, long messageTimeout, SessionFactory sessionFactory) {
        super(sessionFactory);
        this.cxdxResourceAdaptor = cxDxResourceAdaptor;
    }

    public AppSession getNewSession(String sessionId, Class<? extends AppSession> appSessionClass, ApplicationId applicationId, Object[] args) {
        CxDxClientSessionImpl appSession = null;
        if (appSessionClass == ClientCxDxSession.class) {
            CxDxClientSessionImpl clientSession = null;
            appSession = clientSession = (CxDxClientSessionImpl)super.getNewSession(sessionId, appSessionClass, applicationId, args);
        } else if (appSessionClass == ServerCxDxSession.class) {
            CxDxServerSessionImpl serverSession = null;
            serverSession = (CxDxServerSessionImpl)super.getNewSession(sessionId, appSessionClass, applicationId, args);
            appSession = serverSession;
        } else {
            throw new IllegalArgumentException("Wrong session class!![" + appSessionClass + "]. Supported[" + ServerCxDxSession.class + "," + ClientCxDxSession.class + "]");
        }
        return appSession;
    }

    public void doLocationInformationRequest(ServerCxDxSession appSession, JLocationInfoRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doLocationInformationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doMultimediaAuthRequest(ServerCxDxSession appSession, JMultimediaAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doMultimediaAuthRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent(appSession, answer != null ? answer.getMessage() : request.getMessage());
    }

    public void doPushProfileAnswer(ServerCxDxSession appSession, JPushProfileRequest request, JPushProfileAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doPushProfileAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doRegistrationTerminationAnswer(ServerCxDxSession appSession, JRegistrationTerminationRequest request, JRegistrationTerminationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doRegistrationTerminationAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doServerAssignmentRequest(ServerCxDxSession appSession, JServerAssignmentRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doServerAssignmentRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doUserAuthorizationRequest(ServerCxDxSession appSession, JUserAuthorizationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doUserAuthorizationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doLocationInformationAnswer(ClientCxDxSession appSession, JLocationInfoRequest request, JLocationInfoAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doLocationInformationAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doMultimediaAuthAnswer(ClientCxDxSession appSession, JMultimediaAuthRequest request, JMultimediaAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doMultimediaAuthAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doPushProfileRequest(ClientCxDxSession appSession, JPushProfileRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doPushProfileRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doRegistrationTerminationRequest(ClientCxDxSession appSession, JRegistrationTerminationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doRegistrationTerminationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doServerAssignmentAnswer(ClientCxDxSession appSession, JServerAssignmentRequest request, JServerAssignmentAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doServerAssignmentAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doUserAuthorizationAnswer(ClientCxDxSession appSession, JUserAuthorizationRequest request, JUserAuthorizationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: doUserAuthorizationAnswer :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: stateChanged :: source[" + source + "] :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info((Object)("Diameter Cx/Dx Session Factory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public JLocationInfoAnswer createLocationInfoAnswer(Answer answer) {
        return new JLocationInfoAnswerImpl(answer);
    }

    public JLocationInfoRequest createLocationInfoRequest(Request request) {
        return new JLocationInfoRequestImpl((Message)request);
    }

    public JMultimediaAuthAnswer createMultimediaAuthAnswer(Answer answer) {
        return new JMultimediaAuthAnswerImpl(answer);
    }

    public JMultimediaAuthRequest createMultimediaAuthRequest(Request request) {
        return new JMultimediaAuthRequestImpl((Message)request);
    }

    public JPushProfileAnswer createPushProfileAnswer(Answer answer) {
        return new JPushProfileAnswerImpl(answer);
    }

    public JPushProfileRequest createPushProfileRequest(Request request) {
        return new JPushProfileRequestImpl((Message)request);
    }

    public JRegistrationTerminationAnswer createRegistrationTerminationAnswer(Answer answer) {
        return new JRegistrationTerminationAnswerImpl(answer);
    }

    public JRegistrationTerminationRequest createRegistrationTerminationRequest(Request request) {
        return new JRegistrationTerminationRequestImpl((Message)request);
    }

    public JServerAssignmentAnswer createServerAssignmentAnswer(Answer answer) {
        return new JServerAssignmentAnswerImpl(answer);
    }

    public JServerAssignmentRequest createServerAssignmentRequest(Request request) {
        return new JServerAssignmentRequestImpl((Message)request);
    }

    public JUserAuthorizationAnswer createUserAuthorizationAnswer(Answer answer) {
        return new JUserAuthorizationAnswerImpl(answer);
    }

    public JUserAuthorizationRequest createUserAuthorizationRequest(Request request) {
        return new JUserAuthorizationRequestImpl((Message)request);
    }

    public long getApplicationId() {
        return 0x1000000L;
    }

    private void doFireEvent(AppSession appSession, Message message) {
        this.cxdxResourceAdaptor.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), message);
    }
}

