/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.http;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLEncoder {
    private static final Logger logger = LoggerFactory.getLogger(URLEncoder.class);
    private static final int[] urlAllowedCharacters = new int[]{45, 46, 95, 126, 33, 36, 38, 39, 40, 41, 42, 43, 44, 59, 61, 58, 64, 47, 63};

    protected static String encodeURL(String input) {
        try {
            byte[] sourceBytes = URLDecoder.decode(input, Charsets.UTF_8.name()).getBytes(Charsets.UTF_8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(sourceBytes.length);
            for (int n : sourceBytes) {
                int b = n;
                if (b < 0) {
                    b += 256;
                }
                if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || Arrays.binarySearch(urlAllowedCharacters, b) >= 0) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            return new String(bos.toByteArray(), Charsets.UTF_8);
        }
        catch (Exception e) {
            logger.trace("Exception while decoding or encoding url [" + input + "]", (Throwable)e);
            return input;
        }
    }

    static {
        Arrays.sort(urlAllowedCharacters);
        if (logger.isTraceEnabled()) {
            for (int i = 0; i < urlAllowedCharacters.length; ++i) {
                logger.trace("urlAllowedCharacters[" + i + "] = " + (char)urlAllowedCharacters[i]);
            }
        }
    }
}

