/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.model.Parameter;

public class MockServerRequestEncoder
extends MessageToMessageEncoder<OutboundHttpRequest> {
    protected void encode(ChannelHandlerContext ctx, OutboundHttpRequest httpRequest, List<Object> out) {
        HttpMethod httpMethod = HttpMethod.valueOf((String)httpRequest.getMethod("GET"));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest), this.getBody(httpRequest));
        this.setHeader(httpRequest, (FullHttpRequest)request);
        this.setCookies(httpRequest, (FullHttpRequest)request);
        out.add(request);
    }

    public String getURI(OutboundHttpRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.lastIndexOf("/"));
            }
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
        }
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(contextPath + httpRequest.getPath().getValue());
        for (Parameter parameter : httpRequest.getQueryStringParameters()) {
            for (NottableString value : parameter.getValues()) {
                queryStringEncoder.addParam(parameter.getName().getValue(), value.getValue());
            }
        }
        return queryStringEncoder.toString();
    }

    private ByteBuf getBody(HttpRequest httpRequest) {
        ByteBuf content = Unpooled.buffer((int)0, (int)0);
        Body body = httpRequest.getBody();
        if (body != null) {
            Object bodyContents = body.getValue();
            Charset bodyCharset = body.getCharset(ContentTypeMapper.determineCharsetForMessage(httpRequest));
            if (bodyContents instanceof byte[]) {
                content = Unpooled.copiedBuffer((byte[])((byte[])bodyContents));
            } else if (bodyContents instanceof String) {
                content = Unpooled.copiedBuffer((byte[])((String)bodyContents).getBytes(bodyCharset));
            } else if (body.toString() != null) {
                content = Unpooled.copiedBuffer((byte[])body.toString().getBytes(bodyCharset));
            }
        }
        return content;
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest request) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : httpRequest.getCookies()) {
            cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
        }
        if (cookies.size() > 0) {
            request.headers().set("Cookie", (Object)ClientCookieEncoder.LAX.encode(cookies));
        }
    }

    private void setHeader(OutboundHttpRequest httpRequest, FullHttpRequest request) {
        boolean isSsl;
        for (Header header : httpRequest.getHeaders()) {
            String headerName = header.getName().getValue();
            if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding") || headerName.equalsIgnoreCase("Host") || headerName.equalsIgnoreCase("Accept-Encoding")) continue;
            if (!header.getValues().isEmpty()) {
                for (NottableString headerValue : header.getValues()) {
                    request.headers().add(headerName, (Object)headerValue.getValue());
                }
                continue;
            }
            request.headers().add(headerName, (Object)"");
        }
        String port = "";
        boolean bl = isSsl = httpRequest.isSecure() != null && httpRequest.isSecure() != false;
        if (!isSsl && httpRequest.getDestination().getPort() != 80 || isSsl && httpRequest.getDestination().getPort() != 443) {
            port = ":" + httpRequest.getDestination().getPort();
        }
        request.headers().add("Host", (Object)(httpRequest.getDestination().getHostName() + port));
        request.headers().set("Accept-Encoding", (Object)"gzip,deflate");
        request.headers().set("Content-Length", (Object)request.content().readableBytes());
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            request.headers().set("Connection", (Object)"keep-alive");
        } else {
            request.headers().set("Connection", (Object)"close");
        }
        if (!request.headers().contains("Content-Type") && httpRequest.getBody() != null) {
            Charset bodyCharset = httpRequest.getBody().getCharset(null);
            String bodyContentType = httpRequest.getBody().getContentType();
            if (bodyCharset != null) {
                request.headers().set("Content-Type", (Object)(bodyContentType + "; charset=" + bodyCharset.name().toLowerCase()));
            } else if (bodyContentType != null) {
                request.headers().set("Content-Type", (Object)bodyContentType);
            }
        }
    }
}

