/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mockserver.client.serialization.java.CookieToJavaSerializer;
import org.mockserver.client.serialization.java.HeaderToJavaSerializer;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpResponseToJavaSerializer
implements ToJavaSerializer<HttpResponse> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpResponse httpResponse) {
        StringBuffer output = new StringBuffer();
        if (httpResponse != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent, output).append("response()");
            if (httpResponse.getStatusCode() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent + 8, output).append(".withStatusCode(").append(httpResponse.getStatusCode()).append(")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 8, output, httpResponse.getHeaders());
            this.outputCookies(numberOfSpacesToIndent + 8, output, httpResponse.getCookies());
            if (httpResponse.getBodyAsString() != null && httpResponse.getBodyAsString().length() > 0) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent + 8, output).append(".withBody(\"").append(StringEscapeUtils.escapeJava((String)httpResponse.getBodyAsString())).append("\")");
            }
        }
        return output.toString();
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> StringBuffer appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        return output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 8, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

