/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProperties {
    static final long DEFAULT_MAX_TIMEOUT = 120L;
    static final Logger logger = LoggerFactory.getLogger(ConfigurationProperties.class);
    static final Properties PROPERTIES = ConfigurationProperties.readPropertyFile();
    static final Set<String> allSubjectAlternativeDomains = Sets.newConcurrentHashSet();
    static final Set<String> allSubjectAlternativeIps = Sets.newConcurrentHashSet();
    static final AtomicBoolean rebuildKeyStore = new AtomicBoolean(false);

    public static String propertyFile() {
        return System.getProperty("mockserver.propertyFile", "mockserver.properties");
    }

    public static long maxSocketTimeout() {
        return ConfigurationProperties.readLongProperty("mockserver.maxSocketTimeout", TimeUnit.SECONDS.toMillis(120L));
    }

    public static void maxSocketTimeout(long milliseconds) {
        System.setProperty("mockserver.maxSocketTimeout", "" + milliseconds);
    }

    public static String javaKeyStoreFilePath() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreFilePath", SSLFactory.defaultKeyStoreFileName());
    }

    public static void javaKeyStoreFilePath(String keyStoreFilePath) {
        System.setProperty("mockserver.javaKeyStoreFilePath", keyStoreFilePath);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStorePassword() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStorePassword", "changeit");
    }

    public static void javaKeyStorePassword(String keyStorePassword) {
        System.setProperty("mockserver.javaKeyStorePassword", keyStorePassword);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStoreType() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreType", KeyStore.getDefaultType());
    }

    public static void javaKeyStoreType(String keyStoreType) {
        System.setProperty("mockserver.javaKeyStoreType", keyStoreType);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static boolean deleteGeneratedKeyStoreOnExit() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.deleteGeneratedKeyStoreOnExit", "true"));
    }

    public static void deleteGeneratedKeyStoreOnExit(boolean deleteGeneratedKeyStoreOnExit) {
        System.setProperty("mockserver.deleteGeneratedKeyStoreOnExit", "" + deleteGeneratedKeyStoreOnExit);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String sslCertificateDomainName() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.sslCertificateDomainName", "localhost");
    }

    public static void sslCertificateDomainName(String domainName) {
        System.setProperty("mockserver.sslCertificateDomainName", domainName);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String[] sslSubjectAlternativeNameDomains() {
        return allSubjectAlternativeDomains.toArray(new String[allSubjectAlternativeDomains.size()]);
    }

    public static void addSslSubjectAlternativeNameDomains(String ... newSubjectAlternativeNameDomains) {
        boolean subjectAlternativeDomainsModified = false;
        for (String subjectAlternativeDomain : newSubjectAlternativeNameDomains) {
            if (!allSubjectAlternativeDomains.add(subjectAlternativeDomain.trim())) continue;
            subjectAlternativeDomainsModified = true;
        }
        if (subjectAlternativeDomainsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameDomains", Joiner.on((String)",").join(new TreeSet<String>(allSubjectAlternativeDomains)));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static void clearSslSubjectAlternativeNameDomains() {
        allSubjectAlternativeDomains.clear();
        ConfigurationProperties.addSslSubjectAlternativeNameDomains(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameDomains", "localhost").split(","));
    }

    public static boolean containsSslSubjectAlternativeName(String domainOrIp) {
        return allSubjectAlternativeDomains.contains(domainOrIp) || allSubjectAlternativeIps.contains(domainOrIp);
    }

    public static String[] sslSubjectAlternativeNameIps() {
        return allSubjectAlternativeIps.toArray(new String[allSubjectAlternativeIps.size()]);
    }

    public static void addSslSubjectAlternativeNameIps(String ... newSubjectAlternativeNameIps) {
        boolean subjectAlternativeIpsModified = false;
        for (String subjectAlternativeDomain : newSubjectAlternativeNameIps) {
            if (!allSubjectAlternativeIps.add(subjectAlternativeDomain.trim())) continue;
            subjectAlternativeIpsModified = true;
        }
        if (subjectAlternativeIpsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameIps", Joiner.on((String)",").join(new TreeSet<String>(allSubjectAlternativeIps)));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static void clearSslSubjectAlternativeNameIps() {
        allSubjectAlternativeIps.clear();
        ConfigurationProperties.addSslSubjectAlternativeNameIps(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameIps", "127.0.0.1,0.0.0.0").split(","));
    }

    public static boolean rebuildKeyStore() {
        return rebuildKeyStore.get();
    }

    public static void rebuildKeyStore(boolean rebuildKeyStore) {
        ConfigurationProperties.rebuildKeyStore.set(rebuildKeyStore);
    }

    public static int mockServerPort() {
        return ConfigurationProperties.readIntegerProperty("mockserver.mockServerPort", -1);
    }

    public static void mockServerPort(int port) {
        System.setProperty("mockserver.mockServerPort", "" + port);
    }

    public static int proxyPort() {
        return ConfigurationProperties.readIntegerProperty("mockserver.proxyPort", -1);
    }

    public static void proxyPort(int port) {
        System.setProperty("mockserver.proxyPort", "" + port);
    }

    private static Integer readIntegerProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            logger.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", (Throwable)nfe);
            return defaultValue;
        }
    }

    private static Long readLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            logger.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Properties readPropertyFile() {
        Properties properties = new Properties();
        InputStream inputStream = ConfigurationProperties.class.getClassLoader().getResourceAsStream(ConfigurationProperties.propertyFile());
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", (Throwable)e);
            }
        } else {
            logger.debug("Property file not found on classpath using path [" + ConfigurationProperties.propertyFile() + "]");
            try {
                properties.load(new FileInputStream(ConfigurationProperties.propertyFile()));
            }
            catch (FileNotFoundException e) {
                logger.debug("Property file not found using path [" + ConfigurationProperties.propertyFile() + "]");
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", (Throwable)e);
            }
        }
        if (!properties.isEmpty()) {
            IOUtils.closeQuietly((InputStream)inputStream);
            Enumeration<?> propertyNames = properties.propertyNames();
            StringBuilder propertiesLogDump = new StringBuilder();
            propertiesLogDump.append("Reading properties from property file [").append(ConfigurationProperties.propertyFile()).append("]:\n");
            while (propertyNames.hasMoreElements()) {
                String propertyName = String.valueOf(propertyNames.nextElement());
                propertiesLogDump.append("\t").append(propertyName).append(" = ").append(properties.getProperty(propertyName)).append("\n");
            }
            logger.info(propertiesLogDump.toString());
        }
        return properties;
    }

    public static String readPropertyHierarchically(String key, String defaultValue) {
        return System.getProperty(key, PROPERTIES.getProperty(key, defaultValue));
    }

    public static void overrideLogLevel(String level) {
        if (level != null) {
            if (!Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF").contains(level)) {
                throw new IllegalArgumentException("log level \"" + level + "\" is not legel it must be one of \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\"");
            }
            System.setProperty("mockserver.logLevel", level);
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", level);
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.mockserver");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.mockserver.MockServerHandler");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.proxy");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.proxy.http.HttpProxyHandler");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.matchers.HttpRequestMatcher");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.filters.LogFilter");
        }
    }

    private static void overrideLogLevelWithReflection(String level, String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        try {
            Class<?> logbackLevelClass = ConfigurationProperties.class.getClassLoader().loadClass("ch.qos.logback.classic.Level");
            Method toLevelMethod = logbackLevelClass.getDeclaredMethod("toLevel", String.class);
            toLevelMethod.setAccessible(true);
            Object levelInstance = toLevelMethod.invoke(logbackLevelClass, level);
            Method setLevelMethod = logger.getClass().getDeclaredMethod("setLevel", logbackLevelClass);
            if (setLevelMethod != null) {
                setLevelMethod.invoke((Object)logger, levelInstance);
            }
        }
        catch (Exception e) {
            ConfigurationProperties.logger.warn("Exception updating logging level using reflection, likely cause is Logback is not on the classpath");
        }
        try {
            Class<?> loggerClass = logger.getClass();
            if (logger.getClass().getName().equals("org.slf4j.impl.SimpleLogger")) {
                Method stringToLevelMethod = loggerClass.getDeclaredMethod("stringToLevel", String.class);
                stringToLevelMethod.setAccessible(true);
                Object logLevelInstance = stringToLevelMethod.invoke((Object)logger, level);
                Field currentLogLevelField = loggerClass.getDeclaredField("currentLogLevel");
                currentLogLevelField.setAccessible(true);
                currentLogLevelField.set(logger, logLevelInstance);
            }
        }
        catch (Exception e) {
            ConfigurationProperties.logger.warn("Exception updating logging level using reflection, likely cause is Logback is not on the classpath");
        }
    }

    static {
        ConfigurationProperties.addSslSubjectAlternativeNameDomains(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameDomains", "localhost").split(","));
        ConfigurationProperties.addSslSubjectAlternativeNameIps(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameIps", "127.0.0.1,0.0.0.0").split(","));
    }
}

