/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.nio.charset.Charset;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.mockserver.streams.IOStreamUtils;

public class MockServerResponseToHttpServletResponseEncoder {
    public void mapMockServerResponseToHttpServletResponse(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        this.setStatusCode(httpResponse, httpServletResponse);
        this.setHeaders(httpResponse, httpServletResponse);
        this.setCookies(httpResponse, httpServletResponse);
        this.setBody(httpResponse, httpServletResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getStatusCode() != null) {
            httpServletResponse.setStatus(httpResponse.getStatusCode().intValue());
        }
    }

    private void setHeaders(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getHeaders() != null) {
            for (Header header : httpResponse.getHeaders()) {
                String headerName = header.getName().getValue();
                if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding") || headerName.equalsIgnoreCase("Host") || headerName.equalsIgnoreCase("Accept-Encoding") || headerName.equalsIgnoreCase("Connection")) continue;
                for (NottableString value : header.getValues()) {
                    httpServletResponse.addHeader(headerName, value.getValue());
                }
            }
        }
        this.addContentTypeHeader(httpResponse, httpServletResponse);
    }

    private void setCookies(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getCookies() != null) {
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookies()) {
                httpServletResponse.addHeader("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue())));
            }
        }
    }

    private void setBody(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getBodyAsString() != null) {
            if (httpResponse.getBody() instanceof BinaryBody) {
                IOStreamUtils.writeToOutputStream(Base64Converter.base64StringToBytes(httpResponse.getBodyAsString()), (ServletResponse)httpServletResponse);
            } else {
                Charset bodyCharset = httpResponse.getBody().getCharset(ContentTypeMapper.determineCharsetForMessage(httpResponse));
                IOStreamUtils.writeToOutputStream(httpResponse.getBodyAsString().getBytes(bodyCharset), (ServletResponse)httpServletResponse);
            }
        }
    }

    private void addContentTypeHeader(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getBody() != null && Strings.isNullOrEmpty((String)httpServletResponse.getHeader("Content-Type"))) {
            Charset bodyCharset = httpResponse.getBody().getCharset(null);
            String bodyContentType = httpResponse.getBody().getContentType();
            if (bodyCharset != null) {
                httpServletResponse.addHeader("Content-Type", bodyContentType + "; charset=" + bodyCharset.name().toLowerCase());
            } else if (bodyContentType != null) {
                httpServletResponse.addHeader("Content-Type", bodyContentType);
            }
        }
    }
}

