/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.matchers.BodyMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPathStringMatcher
extends BodyMatcher<String> {
    private static Logger logger = LoggerFactory.getLogger(XPathStringMatcher.class);
    private final String matcher;
    private XPathExpression xpathExpression = null;

    public XPathStringMatcher(String matcher) {
        this.matcher = matcher;
        if (StringUtils.isNotEmpty((CharSequence)matcher)) {
            try {
                this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
            }
            catch (XPathExpressionException e) {
                logger.trace("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean matches(final String matched) {
        boolean result = false;
        if (this.xpathExpression == null) {
            logger.warn("Attempting match against null XPath Expression for [" + matched + "]" + new RuntimeException("Attempting match against null XPath Expression for [" + matched + "]"));
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                        logger.debug("SAXParseException while performing match between [" + XPathStringMatcher.this.matcher + "] and [" + matched + "]", (Throwable)exception);
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        logger.debug("SAXParseException while performing match between [" + XPathStringMatcher.this.matcher + "] and [" + matched + "]", (Throwable)exception);
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        logger.debug("SAXParseException while performing match between [" + XPathStringMatcher.this.matcher + "] and [" + matched + "]", (Throwable)exception);
                    }
                });
                result = (Boolean)this.xpathExpression.evaluate(documentBuilder.parse(new InputSource(new StringReader(matched))), XPathConstants.BOOLEAN);
            }
            catch (Exception e) {
                logger.trace("Error while matching xpath [" + this.matcher + "] against string [" + matched + "] assuming no match - " + e.getMessage());
            }
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.reverseResultIfNot(result);
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xpathExpression"};
    }
}

