/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.base.Charsets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mockserver.model.Body;

public class JsonSchemaBody
extends Body {
    private final String jsonSchema;

    public JsonSchemaBody(String jsonSchema) {
        super(Body.Type.JSON_SCHEMA);
        this.jsonSchema = jsonSchema;
    }

    public static JsonSchemaBody jsonSchema(String jsonSchema) {
        return new JsonSchemaBody(jsonSchema);
    }

    public static JsonSchemaBody jsonSchemaFromResource(String jsonSchemaPath) {
        return new JsonSchemaBody(JsonSchemaBody.readFileFromClassPathOrPath(jsonSchemaPath));
    }

    private static String readFileFromClassPathOrPath(String filePath) {
        try {
            InputStream inputStream = JsonSchemaBody.class.getClassLoader().getResourceAsStream(filePath);
            if (inputStream == null) {
                inputStream = new FileInputStream(filePath);
            }
            return IOUtils.toString((InputStream)inputStream, (String)Charsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while loading \"" + filePath + "\"");
        }
    }

    public String getValue() {
        return this.jsonSchema;
    }
}

