/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import org.mockserver.model.HttpRequest;
import org.mockserver.socket.SSLFactory;

public class OutboundHttpRequest
extends HttpRequest {
    private String hostname;
    private int port;
    private String contextPath;

    public OutboundHttpRequest(String hostname, int port, String contextPath, HttpRequest httpRequest) {
        this.hostname = hostname;
        this.port = port;
        this.contextPath = Strings.nullToEmpty((String)contextPath);
        this.secure = httpRequest.secure;
        this.method = httpRequest.method;
        this.path = httpRequest.path;
        this.queryStringParameters = httpRequest.queryStringParameters;
        this.body = httpRequest.body;
        this.headers = httpRequest.headers;
        this.cookies = httpRequest.cookies;
        this.keepAlive = httpRequest.keepAlive;
    }

    public static OutboundHttpRequest outboundRequest(InetSocketAddress inetSocketAddress, String contextPath, HttpRequest httpRequest) {
        if (httpRequest != null) {
            if (inetSocketAddress == null) {
                if (!Strings.isNullOrEmpty((String)httpRequest.getFirstHeader("Host"))) {
                    String[] hostHeaderParts = httpRequest.getFirstHeader("Host").split(":");
                    boolean isSsl = httpRequest.isSecure() != null && httpRequest.isSecure() != false;
                    Integer port = isSsl ? 443 : 80;
                    if (hostHeaderParts.length > 1) {
                        port = Integer.parseInt(hostHeaderParts[1]);
                    }
                    SSLFactory.addSubjectAlternativeName(hostHeaderParts[0]);
                    inetSocketAddress = new InetSocketAddress(hostHeaderParts[0], (int)port);
                } else {
                    throw new IllegalArgumentException("Host header must be provided for requests being forwarded, the following request does not include the \"Host\" header:" + System.getProperty("line.separator") + httpRequest);
                }
            }
            return OutboundHttpRequest.outboundRequest(inetSocketAddress.getHostName(), inetSocketAddress.getPort(), contextPath, httpRequest);
        }
        return null;
    }

    public static OutboundHttpRequest outboundRequest(String hostname, int port, String contextPath, HttpRequest httpRequest) {
        return new OutboundHttpRequest(hostname, port, contextPath, httpRequest);
    }

    public InetSocketAddress getDestination() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public OutboundHttpRequest withSsl(boolean isSsl) {
        if (!isSsl && this.port == 443) {
            this.port = 80;
        } else if (isSsl && this.port == 80) {
            this.port = 443;
        }
        super.withSecure(isSsl);
        return this;
    }
}

