/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.KeyStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLFactory {
    public static final String KEY_STORE_PASSWORD = "changeit";
    public static final String CERTIFICATE_DOMAIN = "localhost";
    public static final String KEY_STORE_CERT_ALIAS = "mockserver-client-cert";
    public static final String KEY_STORE_CA_ALIAS = "mockserver-ca-cert";
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    private static final SSLFactory SSL_FACTORY = new SSLFactory();
    private static SSLContext sslContext;
    private KeyStore keystore;

    private SSLFactory() {
    }

    public static String defaultKeyStoreFileName() {
        if ("jks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jks";
        }
        if ("pkcs12".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.p12";
        }
        if ("jceks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jceks";
        }
        throw new IllegalArgumentException(ConfigurationProperties.javaKeyStoreType() + " is not a supported keystore type");
    }

    public static SSLFactory getInstance() {
        return SSL_FACTORY;
    }

    public static synchronized SSLEngine createClientSSLEngine() {
        SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
        engine.setUseClientMode(true);
        return engine;
    }

    public static synchronized SSLEngine createServerSSLEngine() {
        SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }

    public static void addSubjectAlternativeName(String host) {
        String hostWithoutPort;
        if (host != null && !ConfigurationProperties.containsSslSubjectAlternativeName(hostWithoutPort = StringUtils.substringBefore((String)host, (String)":"))) {
            try {
                for (InetAddress addr : InetAddress.getAllByName(hostWithoutPort)) {
                    ConfigurationProperties.addSslSubjectAlternativeNameIps(addr.getHostAddress());
                    ConfigurationProperties.addSslSubjectAlternativeNameDomains(addr.getHostName());
                    ConfigurationProperties.addSslSubjectAlternativeNameDomains(addr.getCanonicalHostName());
                }
            }
            catch (UnknownHostException uhe) {
                ConfigurationProperties.addSslSubjectAlternativeNameDomains(hostWithoutPort);
            }
        }
    }

    public synchronized SSLSocket wrapSocket(Socket socket) throws Exception {
        SSLSocketFactory sslSocketFactory = this.sslContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(true);
        sslSocket.startHandshake();
        return sslSocket;
    }

    public SSLContext sslContext() {
        if (sslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                KeyManagerFactory keyManagerFactory = this.getKeyManagerFactoryInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.buildKeyStore(), ConfigurationProperties.javaKeyStorePassword().toCharArray());
                sslContext = this.getSSLContextInstance("TLS");
                sslContext.init(keyManagerFactory.getKeyManagers(), InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize the SSLContext", e);
            }
        }
        return sslContext;
    }

    public KeyStore buildKeyStore() {
        if (this.keystore == null || ConfigurationProperties.rebuildKeyStore()) {
            File keyStoreFile = new File(ConfigurationProperties.javaKeyStoreFilePath());
            System.setProperty("javax.net.ssl.trustStore", keyStoreFile.getAbsolutePath());
            if (keyStoreFile.exists()) {
                this.keystore = this.updateExistingKeyStore(keyStoreFile);
            } else {
                this.createNewKeyStore();
            }
            ConfigurationProperties.rebuildKeyStore(false);
        }
        return this.keystore;
    }

    private SSLContext getSSLContextInstance(String protocol) throws NoSuchAlgorithmException {
        return SSLContext.getInstance(protocol);
    }

    private KeyManagerFactory getKeyManagerFactoryInstance(String algorithm) throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance(algorithm);
    }

    private void createNewKeyStore() {
        try {
            this.keystore = new KeyStoreFactory().generateCertificate(null, KEY_STORE_CERT_ALIAS, KEY_STORE_CA_ALIAS, ConfigurationProperties.javaKeyStorePassword().toCharArray(), ConfigurationProperties.sslCertificateDomainName(), ConfigurationProperties.sslSubjectAlternativeNameDomains(), ConfigurationProperties.sslSubjectAlternativeNameIps());
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building KeyStore dynamically", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore updateExistingKeyStore(File keyStoreFile) {
        KeyStore keyStore;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(ConfigurationProperties.javaKeyStoreFilePath());
            logger.trace("Loading key store from file [" + keyStoreFile + "]");
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(fileInputStream, ConfigurationProperties.javaKeyStorePassword().toCharArray());
            new KeyStoreFactory().generateCertificate(keystore, KEY_STORE_CERT_ALIAS, KEY_STORE_CA_ALIAS, ConfigurationProperties.javaKeyStorePassword().toCharArray(), ConfigurationProperties.sslCertificateDomainName(), ConfigurationProperties.sslSubjectAlternativeNameDomains(), ConfigurationProperties.sslSubjectAlternativeNameIps());
            keyStore = keystore;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)fileInputStream);
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while loading KeyStore from " + keyStoreFile.getAbsolutePath(), e);
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return keyStore;
    }
}

