/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.Action;
import org.mockserver.model.Delay;

public class HttpForward
extends Action {
    private String host;
    private Integer port = 80;
    private Scheme scheme = Scheme.HTTP;
    private Delay delay;

    public static HttpForward forward() {
        return new HttpForward();
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.FORWARD;
    }

    public String getHost() {
        return this.host;
    }

    public HttpForward withHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpForward withPort(Integer port) {
        this.port = port;
        return this;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public HttpForward withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpForward withDelay(Delay delay) {
        this.delay = delay;
        return this;
    }

    public HttpForward withDelay(TimeUnit timeUnit, long value) {
        this.delay = new Delay(timeUnit, value);
        return this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public static enum Scheme {
        HTTP,
        HTTPS;

    }
}

