/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.scheduler;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpResponse;

public class Scheduler {
    private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(this.poolSize(), new ThreadPoolExecutor.CallerRunsPolicy());

    private int poolSize() {
        return Math.max(2, Runtime.getRuntime().availableProcessors() * 2);
    }

    public synchronized void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    private synchronized ScheduledExecutorService getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(this.poolSize(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return this.scheduler;
    }

    public void schedule(Runnable command, Delay delay) {
        this.schedule(command, delay, false);
    }

    public void schedule(Runnable command, Delay delay, boolean synchronous) {
        if (synchronous) {
            if (delay != null) {
                delay.applyDelay();
            }
            command.run();
        } else if (delay != null) {
            this.getScheduler().schedule(command, delay.getValue(), delay.getTimeUnit());
        } else {
            command.run();
        }
    }

    public void submit(Runnable command) {
        this.submit(command, false);
    }

    public void submit(Runnable command, boolean synchronous) {
        if (synchronous) {
            command.run();
        } else {
            this.getScheduler().schedule(command, 0L, TimeUnit.NANOSECONDS);
        }
    }

    public void submit(SettableFuture<HttpResponse> future, Runnable command, boolean synchronous) {
        if (future != null) {
            if (synchronous) {
                try {
                    future.get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.setException((Throwable)new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    future.setException((Throwable)ex);
                }
                command.run();
            } else {
                future.addListener(command, (Executor)this.getScheduler());
            }
        }
    }
}

