/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import java.util.EnumSet;

public final class DraftV3TypeKeywordDigester
extends AbstractDigester {
    private static final String ANY = "any";

    public DraftV3TypeKeywordDigester(String keyword) {
        super(keyword, NodeType.ARRAY, NodeType.values());
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode simpleTypes = FACTORY.arrayNode();
        ret.put(this.keyword, simpleTypes);
        ArrayNode schemas = FACTORY.arrayNode();
        ret.put("schemas", schemas);
        JsonNode node = schema.get(this.keyword);
        EnumSet<NodeType> set = EnumSet.noneOf(NodeType.class);
        if (node.isTextual()) {
            DraftV3TypeKeywordDigester.putType(set, node.textValue());
        } else {
            int size = node.size();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                if (element.isTextual()) {
                    DraftV3TypeKeywordDigester.putType(set, element.textValue());
                    continue;
                }
                schemas.add(index);
            }
        }
        if (EnumSet.complementOf(set).isEmpty()) {
            schemas.removeAll();
        }
        for (NodeType type : set) {
            simpleTypes.add(type.toString());
        }
        return ret;
    }

    private static void putType(EnumSet<NodeType> types, String s) {
        if (ANY.equals(s)) {
            types.addAll(EnumSet.allOf(NodeType.class));
            return;
        }
        NodeType type = NodeType.fromName(s);
        types.add(type);
        if (type == NodeType.NUMBER) {
            types.add(NodeType.INTEGER);
        }
    }
}

