/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.base.Strings;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.ssl.NotSslRecordException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.mockserver.character.Character;
import org.mockserver.client.netty.HttpClientInitializer;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse sendRequest(HttpRequest httpRequest) throws SocketConnectionException {
        return this.sendRequest(httpRequest, this.socketAddressFromHostHeader(httpRequest));
    }

    private InetSocketAddress socketAddressFromHostHeader(HttpRequest request) {
        if (!Strings.isNullOrEmpty(request.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            boolean isSsl = request.isSecure() != null && request.isSecure() != false;
            String[] hostHeaderParts = request.getFirstHeader(HttpHeaderNames.HOST.toString()).split(":");
            return new InetSocketAddress(hostHeaderParts[0], hostHeaderParts.length > 1 ? Integer.parseInt(hostHeaderParts[1]) : (isSsl ? 443 : 80));
        }
        throw new IllegalArgumentException("Host header must be provided for requests being forwarded, the following request does not include the \"Host\" header:" + Character.NEW_LINE + request);
    }

    public HttpResponse sendRequest(final HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) throws SocketConnectionException {
        if (remoteAddress == null) {
            remoteAddress = this.socketAddressFromHostHeader(httpRequest);
        }
        this.logger.debug("Sending to: {} request: {}", (Object)remoteAddress, (Object)httpRequest);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            final HttpClientInitializer channelInitializer = new HttpClientInitializer(httpRequest.isSecure() != null && httpRequest.isSecure() != false, remoteAddress);
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).handler(channelInitializer)).connect(remoteAddress).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        future.channel().writeAndFlush(httpRequest);
                    } else {
                        channelInitializer.getResponseFuture().setException(future.cause());
                    }
                }
            });
            HttpResponse httpResponse = (HttpResponse)channelInitializer.getResponseFuture().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
            this.logger.trace("Received response: {}", (Object)httpResponse);
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (TimeoutException e) {
            throw new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException) {
                throw new SocketConnectionException("Unable to connect to socket " + remoteAddress, cause);
            }
            if (cause instanceof UnknownHostException) {
                throw new SocketConnectionException("Unable to resolve host " + remoteAddress, cause);
            }
            if (cause instanceof NotSslRecordException) {
                HttpResponse httpResponse = this.sendRequest(httpRequest.withSecure(false));
                return httpResponse;
            }
            if (cause instanceof IOException) {
                throw new SocketConnectionException(cause.getMessage(), cause);
            }
            throw new RuntimeException("Exception while sending request - " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Exception while sending request", e);
        }
        finally {
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
        }
    }
}

