/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.NotDTO;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;

public class HttpRequestDTO
extends NotDTO
implements DTO<HttpRequest> {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters queryStringParameters = new Parameters(new Parameter[0]);
    private BodyDTO body;
    private Cookies cookies = new Cookies(new Cookie[0]);
    private Headers headers = new Headers(new Header[0]);
    private Boolean keepAlive = null;
    private Boolean secure = null;

    public HttpRequestDTO(HttpRequest httpRequest) {
        this(httpRequest, false);
    }

    public HttpRequestDTO(HttpRequest httpRequest, Boolean not) {
        super(not);
        if (httpRequest != null) {
            this.method = httpRequest.getMethod();
            this.path = httpRequest.getPath();
            this.headers = httpRequest.getHeaders();
            this.cookies = httpRequest.getCookies();
            this.queryStringParameters = httpRequest.getQueryStringParameters();
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
        }
    }

    public HttpRequestDTO() {
    }

    @Override
    public HttpRequest buildObject() {
        return new HttpRequest().withMethod(this.method).withPath(this.path).withHeaders(this.headers).withCookies(this.cookies).withQueryStringParameters(this.queryStringParameters).withBody(this.body != null ? Not.not(this.body.buildObject(), this.body.getNot()) : null).withSecure(this.secure).withKeepAlive(this.keepAlive);
    }

    public NottableString getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(NottableString path) {
        this.path = path;
        return this;
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestDTO setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequestDTO setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public HttpRequestDTO setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }
}

