/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration;

import java.util.List;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.ProxyBuilder;

public class ClientAndProxy
extends ProxyClient {
    private final Proxy httpProxy;

    public ClientAndProxy(Integer port) {
        super("localhost", port);
        this.httpProxy = new ProxyBuilder().withLocalPort(port).build();
    }

    public ClientAndProxy(Integer port, String remoteHost, Integer remotePort) {
        super("localhost", port);
        this.httpProxy = new ProxyBuilder().withLocalPort(port).withDirect(remoteHost, remotePort).build();
    }

    public static ClientAndProxy startClientAndProxy(Integer port) {
        return new ClientAndProxy(port);
    }

    public static ClientAndProxy startClientAndDirectProxy(Integer port, String remoteHost, Integer remotePort) {
        return new ClientAndProxy(port, remoteHost, remotePort);
    }

    @Override
    public boolean isRunning() {
        return this.httpProxy.isRunning();
    }

    public Integer getPort() {
        return this.httpProxy.getPort();
    }

    public List<Integer> getPorts() {
        return this.httpProxy.getPorts();
    }
}

