/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.matchers.BodyMatcher;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;

public class JsonSchemaMatcher
extends BodyMatcher<String> {
    private final String schema;
    private JsonSchemaValidator jsonSchemaValidator;

    public JsonSchemaMatcher(String schema) {
        this.schema = schema;
        this.jsonSchemaValidator = new JsonSchemaValidator(schema);
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "jsonSchemaValidator"};
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        try {
            String validation = this.jsonSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.logger.trace("Failed to perform JSON match \"{}\" with schema \"{}\" because {}", matched, this.schema, validation);
            }
        }
        catch (Exception e) {
            this.logger.trace("Failed to perform JSON match \"{}\" with schema \"{}\" because {}", matched, this.schema, e.getMessage());
        }
        return this.reverseResultIfNot(result);
    }
}

