/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;

public class StringBody
extends BodyWithContentType<String> {
    private final String value;
    private final byte[] rawBinaryData;

    public StringBody(String value) {
        this(value, (MediaType)null);
    }

    public StringBody(String value, Charset charset) {
        this(value, charset != null ? MediaType.create("text", "plain").withCharset(charset) : null);
    }

    public StringBody(String value, MediaType contentType) {
        super(Body.Type.STRING, contentType);
        this.value = value;
        this.rawBinaryData = value != null ? value.getBytes(this.determineCharacterSet(contentType, ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET)) : new byte[0];
    }

    public static StringBody exact(String body) {
        return new StringBody(body);
    }

    public static StringBody exact(String body, Charset charset) {
        return new StringBody(body, charset);
    }

    public static StringBody exact(String body, MediaType contentType) {
        return new StringBody(body, contentType);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBinaryData;
    }

    @Override
    public String toString() {
        return this.value;
    }
}

