/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.curl.HttpRequestToCurlSerializer;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mockserver.NettyResponseWriter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private LoggingFormatter logFormatter;
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private Proxy server;
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer = new HttpRequestToCurlSerializer();

    public HttpProxyHandler(Proxy server, HttpStateHandler httpStateHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.logFormatter = httpStateHandler.getLogFormatter();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block13: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                if (this.httpStateHandler.handle(request, responseWriter, false)) break block13;
                if (request.matches("PUT", "/status")) {
                    ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getPorts())), "application/json");
                    break block13;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block13;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create("text", "plain").toString());
                            break block13;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush(HttpResponse.response().withStatusCode(HttpResponseStatus.OK.code()));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HttpProxyHandler.this.server.stop();
                        }
                    }).start();
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                    KeyAndCertificateFactory.addSubjectAlternativeName(request.getPath().getValue());
                    ctx.pipeline().addLast(new HttpConnectHandler(request.getPath().getValue(), -1));
                    ctx.pipeline().remove(this);
                    ctx.fireChannelRead(request);
                } else {
                    InetSocketAddress remoteAddress = ctx.channel().attr(Proxy.REMOTE_SOCKET).get();
                    HttpResponse response = this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(request), remoteAddress);
                    if (response == null) {
                        response = HttpResponse.notFoundResponse();
                    }
                    ((ResponseWriter)responseWriter).writeResponse(request, response);
                    this.httpStateHandler.log(new RequestResponseLogEntry(request, response));
                    this.logFormatter.infoLog(request, "returning response:{}" + Character.NEW_LINE + " for request as json:{}" + Character.NEW_LINE + " as curl:{}", response, request, this.httpRequestToCurlSerializer.toCurl(request, remoteAddress));
                }
            }
            catch (IllegalArgumentException iae) {
                this.logFormatter.errorLog(request, (Throwable)iae, "Exception processing " + request, new Object[0]);
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create("text", "plain").toString());
            }
            catch (Exception e) {
                this.logFormatter.errorLog(request, (Throwable)e, "Exception processing " + request, new Object[0]);
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.BAD_REQUEST.code()).withBody(e.getMessage()));
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

