/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.LogEventJsonSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.ui.MockServerLogListener;
import org.mockserver.ui.MockServerMatcherListener;
import org.mockserver.ui.model.ValueWithKey;

@ChannelHandler.Sharable
public class DashboardWebSocketServerHandler
extends ChannelInboundHandlerAdapter
implements MockServerLogListener,
MockServerMatcherListener {
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET = AttributeKey.valueOf((String)"CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI = "/_mockserver_ui_websocket";
    private final MockServerLogger mockServerLogger;
    private WebSocketServerHandshaker handshaker;
    private CircularHashMap<ChannelHandlerContext, HttpRequest> clientRegistry = new CircularHashMap(100);
    private HttpRequestSerializer httpRequestSerializer;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private MockServerMatcher mockServerMatcher;
    private MockServerEventLog mockServerLog;
    private Function<ObjectWithReflectiveEqualsHashCodeToString, Object> wrapValueWithKey = new Function<ObjectWithReflectiveEqualsHashCodeToString, Object>(){

        public ValueWithKey apply(ObjectWithReflectiveEqualsHashCodeToString input) {
            return new ValueWithKey(input);
        }
    };
    private LogEventJsonSerializer logEventJsonSerializer;

    public DashboardWebSocketServerHandler(HttpStateHandler httpStateHandler) {
        this.mockServerMatcher = httpStateHandler.getMockServerMatcher();
        this.mockServerMatcher.registerListener((MockServerMatcherListener)this);
        this.mockServerLog = httpStateHandler.getMockServerLog();
        this.mockServerLog.registerListener((MockServerLogListener)this);
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
        this.logEventJsonSerializer = new LogEventJsonSerializer(this.mockServerLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).set((Object)true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get() != null && ((Boolean)ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get()).booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(final ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory("ws://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI, null, true, Integer.MAX_VALUE).newHandshaker((io.netty.handler.codec.http.HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), httpRequest, (HttpHeaders)new DefaultHttpHeaders(), ctx.channel().newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DashboardWebSocketServerHandler.this.clientRegistry.put((Object)ctx, (Object)HttpRequest.request());
                }
            });
        }
    }

    private void handleWebSocketFrame(final ChannelHandlerContext ctx, WebSocketFrame frame) throws JsonProcessingException {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    DashboardWebSocketServerHandler.this.clientRegistry.remove((Object)ctx);
                }
            });
        } else if (frame instanceof TextWebSocketFrame) {
            try {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(((TextWebSocketFrame)frame).text());
                this.clientRegistry.put((Object)ctx, (Object)httpRequest);
                this.sendUpdate(httpRequest, ctx);
            }
            catch (IllegalArgumentException iae) {
                this.sendMessage(ctx, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"error", (Object)iae.getMessage()));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, ImmutableMap<String, Object> message) throws JsonProcessingException {
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(this.objectMapper.writeValueAsString(message)));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error("web socket server caught exception", cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.mockServerMatcher.unregisterListener((MockServerMatcherListener)this);
        this.mockServerLog.unregisterListener((MockServerLogListener)this);
        ctx.fireChannelInactive();
    }

    public void updated(MockServerEventLog mockServerLog) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    public void updated(MockServerMatcher mockServerMatcher) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    private void sendUpdate(HttpRequest httpRequest, ChannelHandlerContext channelHandlerContext) {
        try {
            this.sendMessage(channelHandlerContext, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"activeExpectations", (Object)Lists.transform((List)this.mockServerMatcher.retrieveExpectations(httpRequest), this.wrapValueWithKey), (Object)"recordedExpectations", (Object)Lists.transform((List)this.mockServerLog.retrieveExpectations(httpRequest), this.wrapValueWithKey), (Object)"recordedRequests", (Object)Lists.transform((List)this.mockServerLog.retrieveRequestLogEntries(httpRequest), this.wrapValueWithKey), (Object)"logMessages", (Object)Lists.transform((List)this.mockServerLog.retrieveMessageLogEntries(httpRequest), (Function)new Function<MessageLogEntry, Object>(){

                public ValueWithKey apply(MessageLogEntry input) {
                    return new ValueWithKey(DashboardWebSocketServerHandler.this.logEventJsonSerializer.serialize(input), input.key());
                }
            })));
        }
        catch (JsonProcessingException jpe) {
            this.mockServerLogger.error("Exception while updating UI", (Throwable)jpe);
        }
    }
}

