/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.text.SimpleDateFormat;
import java.util.Locale;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.filesystem.DirectoryListingFormatter;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.Permissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixDirectoryListingFormatter
implements DirectoryListingFormatter {
    private static final Logger LOG = LoggerFactory.getLogger((Class)UnixDirectoryListingFormatter.class);
    private static final String DATE_FORMAT = "MMM dd  yyyy";
    private static final int SIZE_WIDTH = 15;
    private static final int OWNER_WIDTH = 8;
    private static final int GROUP_WIDTH = 8;
    private static final String NONE = "none";
    private Locale locale = Locale.ENGLISH;

    public String format(FileSystemEntry fileSystemEntry) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, this.locale);
        String dateStr = dateFormat.format(fileSystemEntry.getLastModified());
        String dirOrFile = fileSystemEntry.isDirectory() ? "d" : "-";
        Permissions permissions = fileSystemEntry.getPermissions() != null ? fileSystemEntry.getPermissions() : Permissions.DEFAULT;
        String permissionsStr = StringUtil.padRight(permissions.asRwxString(), 9);
        String linkCountStr = "1";
        String ownerStr = StringUtil.padRight(this.stringOrNone(fileSystemEntry.getOwner()), 8);
        String groupStr = StringUtil.padRight(this.stringOrNone(fileSystemEntry.getGroup()), 8);
        String sizeStr = StringUtil.padLeft(Long.toString(fileSystemEntry.getSize()), 15);
        String listing = "" + dirOrFile + permissionsStr + "  " + linkCountStr + " " + ownerStr + " " + groupStr + " " + sizeStr + " " + dateStr + " " + fileSystemEntry.getName();
        LOG.info("listing=[" + listing + "]");
        return listing;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String stringOrNone(String string) {
        return string == null ? NONE : string;
    }
}

