/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.internal.junit.JUnitSessionStore;
import org.mockito.junit.MockitoRule;
import org.mockito.plugins.MockitoLogger;
import org.mockito.quality.Strictness;

public final class JUnitRule
implements MockitoRule {
    private final JUnitSessionStore sessionStore;

    public JUnitRule(MockitoLogger logger, Strictness strictness) {
        this.sessionStore = new JUnitSessionStore(logger, strictness);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.sessionStore.createStatement(base, target.getClass().getSimpleName() + "." + method.getName(), target);
    }

    @Override
    public MockitoRule silent() {
        return this.strictness(Strictness.LENIENT);
    }

    @Override
    public MockitoRule strictness(Strictness strictness) {
        this.sessionStore.setStrictness(strictness);
        return this;
    }
}

