/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.junit.jupiter;

import java.lang.reflect.Parameter;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.session.MockitoSessionLogger;

public class MockitoExtension
implements TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace MOCKITO = ExtensionContext.Namespace.create((Object[])new Object[]{"org.mockito"});
    private static final String SESSION = "session";
    private static final String TEST_INSTANCE = "testInstance";
    private final Strictness strictness;

    public MockitoExtension() {
        this(Strictness.STRICT_STUBS);
    }

    private MockitoExtension(Strictness strictness) {
        this.strictness = strictness;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        context.getStore(MOCKITO).put((Object)TEST_INSTANCE, testInstance);
    }

    public void beforeEach(ExtensionContext context) {
        LinkedHashSet<Object> testInstances = new LinkedHashSet<Object>();
        testInstances.add(context.getRequiredTestInstance());
        this.collectParentTestInstances(context, testInstances);
        Strictness actualStrictness = this.retrieveAnnotationFromTestClasses(context).map(MockitoSettings::strictness).orElse(this.strictness);
        MockitoSession session = Mockito.mockitoSession().initMocks(testInstances.toArray()).strictness(actualStrictness).logger((MockitoSessionLogger)new MockitoSessionLoggerAdapter(Plugins.getMockitoLogger())).startMocking();
        context.getStore(MOCKITO).put((Object)SESSION, (Object)session);
    }

    private Optional<MockitoSettings> retrieveAnnotationFromTestClasses(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), MockitoSettings.class);
            if (!currentContext.getParent().isPresent()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (!annotation.isPresent() && currentContext != context.getRoot());
        return annotation;
    }

    private void collectParentTestInstances(ExtensionContext context, Set<Object> testInstances) {
        Optional parent = context.getParent();
        while (parent.isPresent() && parent.get() != context.getRoot()) {
            ExtensionContext parentContext = (ExtensionContext)parent.get();
            Object testInstance = parentContext.getStore(MOCKITO).remove((Object)TEST_INSTANCE);
            if (testInstance != null) {
                testInstances.add(testInstance);
            }
            parent = parentContext.getParent();
        }
    }

    public void afterEach(ExtensionContext context) {
        ((MockitoSession)context.getStore(MOCKITO).remove((Object)SESSION, MockitoSession.class)).finishMocking();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(Mock.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return MockAnnotationProcessor.processAnnotationForMock((Mock)((Mock)parameterContext.findAnnotation(Mock.class).get()), parameter.getType(), (String)parameter.getName());
    }
}

