/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandBatchCursorHelper;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorResourceManager;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class AsyncCommandBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private final OperationContext operationContext;
    private final TimeoutMode timeoutMode;
    private final AtomicBoolean processedInitial = new AtomicBoolean();
    private int batchSize;
    private volatile CommandCursorResult<T> commandCursorResult;
    private boolean resetTimeoutWhenClosing;

    AsyncCommandBatchCursor(TimeoutMode timeoutMode, BsonDocument commandCursorDocument, int batchSize, long maxTimeMS, Decoder<T> decoder, @Nullable BsonValue comment, AsyncConnectionSource connectionSource, AsyncConnection connection) {
        ConnectionDescription connectionDescription = connection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", commandCursorDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = batchSize;
        this.decoder = decoder;
        this.comment = comment;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        this.operationContext = connectionSource.getOperationContext();
        this.timeoutMode = timeoutMode;
        this.operationContext.getTimeoutContext().setMaxTimeOverride(maxTimeMS);
        AsyncConnection connectionToPin = connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? connection : null;
        this.resourceManager = new ResourceManager(this.namespace, connectionSource, connectionToPin, this.commandCursorResult.getServerCursor());
        this.resetTimeoutWhenClosing = true;
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resourceManager.execute(funcCallback -> {
            this.checkTimeoutModeAndResetTimeoutContextIfIteration();
            ServerCursor localServerCursor = this.resourceManager.getServerCursor();
            boolean serverCursorIsNull = localServerCursor == null;
            List batchResults = Collections.emptyList();
            if (!this.processedInitial.getAndSet(true) && !this.firstBatchEmpty) {
                batchResults = this.commandCursorResult.getResults();
            }
            if (serverCursorIsNull || !batchResults.isEmpty()) {
                this.commandCursorResult = CommandCursorResult.withEmptyResults(this.commandCursorResult);
                funcCallback.onResult(batchResults, null);
            } else {
                this.getMore(localServerCursor, funcCallback);
            }
        }, callback);
    }

    @Override
    public boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Nullable
    ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            return null;
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    void checkTimeoutModeAndResetTimeoutContextIfIteration() {
        if (this.timeoutMode == TimeoutMode.ITERATION) {
            this.operationContext.getTimeoutContext().resetTimeoutIfPresent();
        }
    }

    private void getMore(ServerCursor cursor, SingleResultCallback<List<T>> callback) {
        this.resourceManager.executeWithConnection((connection, wrappedCallback) -> this.getMoreLoop(Assertions.assertNotNull(connection), cursor, wrappedCallback), callback);
    }

    private void getMoreLoop(AsyncConnection connection, ServerCursor serverCursor, SingleResultCallback<List<T>> callback) {
        connection.commandAsync(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), connection.getDescription(), this.namespace, this.batchSize, this.comment), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), Assertions.assertNotNull((AsyncConnectionSource)this.resourceManager.getConnectionSource()).getOperationContext(), (commandResult, t) -> {
            if (t != null) {
                Throwable translatedException = t instanceof MongoCommandException ? CommandBatchCursorHelper.translateCommandException((MongoCommandException)t, serverCursor) : t;
                callback.onResult(null, translatedException);
                return;
            }
            this.commandCursorResult = this.toCommandCursorResult(connection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(commandResult));
            ServerCursor nextServerCursor = this.commandCursorResult.getServerCursor();
            this.resourceManager.setServerCursor(nextServerCursor);
            List<T> nextBatch = this.commandCursorResult.getResults();
            if (nextServerCursor == null || !nextBatch.isEmpty()) {
                this.commandCursorResult = CommandCursorResult.withEmptyResults(this.commandCursorResult);
                callback.onResult(nextBatch, null);
                return;
            }
            if (!this.resourceManager.operable()) {
                callback.onResult(Collections.emptyList(), null);
                return;
            }
            this.getMoreLoop(connection, nextServerCursor, callback);
        });
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String fieldNameContainingBatch, BsonDocument commandCursorDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, fieldNameContainingBatch, commandCursorDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        return commandCursorResult;
    }

    AsyncCommandBatchCursor<T> disableTimeoutResetWhenClosing() {
        this.resetTimeoutWhenClosing = false;
        return this;
    }

    @ThreadSafe
    private final class ResourceManager
    extends CursorResourceManager<AsyncConnectionSource, AsyncConnection> {
        ResourceManager(MongoNamespace namespace, @Nullable AsyncConnectionSource connectionSource, @Nullable AsyncConnection connectionToPin, ServerCursor serverCursor) {
            super(namespace, connectionSource, connectionToPin, serverCursor);
        }

        <R> void execute(AsyncCallbackSupplier<R> operation, SingleResultCallback<R> callback) {
            boolean canStartOperation = Assertions.doesNotThrow(this::tryStartOperation);
            if (!canStartOperation) {
                callback.onResult(null, new IllegalStateException("Cursor has been closed"));
            } else {
                operation.whenComplete(() -> {
                    this.endOperation();
                    if (super.getServerCursor() == null) {
                        this.close();
                    }
                }).get(callback);
            }
        }

        @Override
        void markAsPinned(AsyncConnection connectionToPin, Connection.PinningMode pinningMode) {
            connectionToPin.markAsPinned(pinningMode);
        }

        @Override
        void doClose() {
            TimeoutContext timeoutContext = AsyncCommandBatchCursor.this.operationContext.getTimeoutContext();
            timeoutContext.resetToDefaultMaxTime();
            SingleResultCallback<Void> thenDoNothing = (r, t) -> {};
            if (AsyncCommandBatchCursor.this.resetTimeoutWhenClosing) {
                timeoutContext.doWithResetTimeout(this::releaseResourcesAsync, thenDoNothing);
            } else {
                this.releaseResourcesAsync(thenDoNothing);
            }
        }

        private void releaseResourcesAsync(SingleResultCallback<Void> callback) {
            AsyncRunnable.beginAsync().thenRunTryCatchAsyncBlocks(c -> {
                if (this.isSkipReleasingServerResourcesOnClose()) {
                    this.unsetServerCursor();
                }
                if (super.getServerCursor() != null) {
                    AsyncRunnable.beginAsync().thenSupply(c2 -> this.getConnection(c2)).thenConsume((connection, c3) -> AsyncRunnable.beginAsync().thenRun(c4 -> this.releaseServerResourcesAsync((AsyncConnection)connection, c4)).thenAlwaysRunAndFinish(() -> connection.release(), c3)).finish(c);
                } else {
                    c.complete(c);
                }
            }, MongoException.class, (e, c5) -> c5.complete(c5)).thenAlwaysRunAndFinish(() -> {
                this.unsetServerCursor();
                this.releaseClientResources();
            }, callback);
        }

        <R> void executeWithConnection(AsyncOperationHelper.AsyncCallableConnectionWithCallback<R> callable, SingleResultCallback<R> callback) {
            this.getConnection((connection, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                    return;
                }
                callable.call(Assertions.assertNotNull(connection), (result, t1) -> {
                    if (t1 != null) {
                        this.handleException((AsyncConnection)connection, t1);
                    }
                    connection.release();
                    callback.onResult(result, t1);
                });
            });
        }

        private void handleException(AsyncConnection connection, Throwable exception) {
            if (exception instanceof MongoOperationTimeoutException && exception.getCause() instanceof MongoSocketException) {
                this.onCorruptedConnection(connection, (MongoSocketException)exception.getCause());
            } else if (exception instanceof MongoSocketException) {
                this.onCorruptedConnection(connection, (MongoSocketException)exception);
            }
        }

        private void getConnection(SingleResultCallback<AsyncConnection> callback) {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            AsyncConnection pinnedConnection = (AsyncConnection)this.getPinnedConnection();
            if (pinnedConnection != null) {
                callback.onResult(Assertions.assertNotNull(pinnedConnection).retain(), null);
            } else {
                Assertions.assertNotNull((AsyncConnectionSource)this.getConnectionSource()).getConnection(callback);
            }
        }

        private void releaseServerResourcesAsync(AsyncConnection connection, SingleResultCallback<Void> callback) {
            AsyncRunnable.beginAsync().thenRun(c -> {
                ServerCursor localServerCursor = super.getServerCursor();
                if (localServerCursor != null) {
                    this.killServerCursorAsync(this.getNamespace(), localServerCursor, connection, callback);
                } else {
                    c.complete(c);
                }
            }).thenAlwaysRunAndFinish(() -> this.unsetServerCursor(), callback);
        }

        private void killServerCursorAsync(MongoNamespace namespace, ServerCursor localServerCursor, AsyncConnection localConnection, SingleResultCallback<Void> callback) {
            localConnection.commandAsync(namespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(namespace, localServerCursor), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), AsyncCommandBatchCursor.this.operationContext, (r, t) -> callback.onResult(null, null));
        }
    }
}

