/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Java8DBCursorCleaner;
import com.mongodb.Java9DBCursorCleaner;
import com.mongodb.MongoClient;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerCursor;

abstract class DBCursorCleaner {
    private static final boolean CLEANER_IS_AVAILABLE;

    DBCursorCleaner() {
    }

    static DBCursorCleaner create(MongoClient mongoClient, MongoNamespace namespace, ServerCursor serverCursor) {
        if (CLEANER_IS_AVAILABLE) {
            return new Java9DBCursorCleaner(mongoClient, namespace, serverCursor);
        }
        return new Java8DBCursorCleaner(mongoClient, namespace, serverCursor);
    }

    abstract void clearCursor();

    static {
        boolean cleanerIsAvailable = false;
        try {
            Class.forName("java.lang.ref.Cleaner");
            cleanerIsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CLEANER_IS_AVAILABLE = cleanerIsAvailable;
    }
}

