/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoClients;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(AsyncMongoClients.create((ConnectionString)connectionString, (MongoDriverInformation)MongoClients.wrapMongoDriverInformation(mongoDriverInformation)));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(AsyncMongoClients.create((MongoClientSettings)settings, (MongoDriverInformation)MongoClients.wrapMongoDriverInformation(mongoDriverInformation)));
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return AsyncMongoClients.getDefaultCodecRegistry();
    }

    private static MongoClient create(AsyncMongoClient asyncMongoClient) {
        return new MongoClientImpl(asyncMongoClient);
    }

    private static MongoDriverInformation wrapMongoDriverInformation(MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation)).driverName("reactive-streams").build();
    }

    private MongoClients() {
    }
}

